angular.module('fusioApp').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('app/account/nav.html',
    "<nav class=fusio-nav><div class=fusio-nav-group><h3>Account</h3><ul><li><a ng-href=#!/account>Profile</a></li><li><a ng-href=#!/account/security>Security</a></li><li ng-if=\"account.scopes.includes('consumer.grant')\"><a ng-href=#!/account/grant>Grants</a></li><li ng-if=\"account.scopes.includes('consumer.app')\"><a ng-href=#!/account/app>Apps</a></li><li ng-if=\"account.scopes.includes('consumer.subscription')\"><a ng-href=#!/account/subscription>Subscriptions</a></li><li ng-if=\"account.scopes.includes('consumer.plan')\"><a ng-href=#!/account/plan>Plans</a></li><li ng-if=\"account.scopes.includes('consumer.plan')\"><a ng-href=#!/account/contract>Contracts</a></li><li ng-if=\"account.scopes.includes('consumer.plan')\"><a ng-href=#!/account/invoice>Invoices</a></li></ul></div></nav>"
  );


  $templateCache.put('app/auth/grant.html',
    "<div class=\"container fusio-login-container\"><h1>Authorization</h1><div uib-alert ng-class=\"'alert-danger'\" ng-if=error>{{error}}</div><div uib-alert ng-class=\"'alert-info'\" ng-if=info>{{info}}</div><div ng-if=response.code><div uib-alert ng-class=\"'alert-info'\">You have granted the application access. Provide the following authorization code in order to complete the authentication process.</div><p><b>Authorization code:</b></p><div class=fusio-code>{{ response.code }}</div></div><div ng-if=\"app.name && !response.code && !info\"><p><a href=\"{{ app.url }}\">{{ app.name }}</a> is requesting permission to access:</p><ul><li ng-repeat=\"scope in app.scopes\"><b>{{ scope.description }}</b></li></ul><hr><div><button ng-click=submitAccess(1) class=\"btn btn-primary\">Allow Access</button> <button ng-click=submitAccess(0) class=\"btn btn-default\">No thanks</button></div></div></div>"
  );


  $templateCache.put('app/documentation/documentation.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\"><nav class=fusio-nav><div class=fusio-nav-group><h3>Index</h3><ul><li ng-repeat=\"row in pages\"><a ng-href=\"#!/documentation/{{ row.slug }}\">{{ row.title }}</a></li></ul></div></nav></div><div class=col-md-10><h2>{{ page.title }}</h2><div ng-bind-html=page.content></div></div></div>"
  );


  $templateCache.put('app/login/login.html',
    "<div class=fusio-login-container><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form id=loginForm method=POST ng-submit=login(user)><h1>Login</h1><div class=\"form-group has-feedback\"><input ng-model=user.username id=username required placeholder=Username class=form-control> <span class=\"ion-person form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><input type=password ng-model=user.password id=password required placeholder=Password class=form-control> <span class=\"ion-key form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><button type=submit ng-disabled=\"user.username == '' || user.password == ''\" class=\"btn btn-block btn-default\">Login</button></div></form><div class=fusio-login-ruler></div><p class=\"text-center text-muted\"><small><a ng-href=#!/register>Sign up</a> or <a ng-href=#!/password/reset>Forgot password</a></small></p><button ng-if=\"isConfigured('facebook')\" ng-click=\"authenticate('facebook')\" class=\"btn btn-block btn-facebook\"><i class=ion-social-facebook></i> Sign in with Facebook</button> <button ng-if=\"isConfigured('google')\" ng-click=\"authenticate('google')\" class=\"btn btn-block btn-google-plus\"><i class=ion-social-google></i> Sign in with Google</button> <button ng-if=\"isConfigured('github')\" ng-click=\"authenticate('github')\" class=\"btn btn-block btn-github\"><i class=ion-social-github></i> Sign in with GitHub</button></div>"
  );


  $templateCache.put('app/logout/logout.html',
    "<p>Logging out ...</p>"
  );


  $templateCache.put('app/overview/overview.html',
    "<div ng-bind-html=page.content></div>"
  );


  $templateCache.put('app/password/confirm.html',
    "<div class=\"container fusio-login-container\"><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">Password reset successful. You can now <a ng-href=#!/login>Log in</a> with your new password.</div><form id=passwordConfirmForm method=POST ng-submit=confirm(user) ng-hide=\"response.success == true\"><h1>Reset password</h1><div class=\"form-group has-feedback\"><input type=password class=form-control id=password ng-model=user.password required placeholder=Password> <span class=\"ion-key form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><input type=password class=form-control id=passwordRepeat ng-model=user.passwordRepeat required placeholder=\"Confirm Password\"> <span class=\"ion-key form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><button type=submit ng-disabled=\"user.password == '' || user.password != user.passwordRepeat\" class=\"btn btn-block btn-default\">Reset password</button></div></form><div class=fusio-login-ruler></div><p class=\"text-center text-muted\"><small><a ng-href=#!/login>Log in</a> if you already have an account</small></p></div>"
  );


  $templateCache.put('app/password/reset.html',
    "<div class=\"container fusio-login-container\"><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">Password reset successful. We have send you an link to reset your password.</div><form id=passwordResetForm method=POST ng-submit=reset(user) ng-hide=\"response.success == true\"><h1>Password reset</h1><div class=\"form-group has-feedback\"><input type=email class=form-control id=email ng-model=user.email required placeholder=Email> <span class=\"ion-at form-control-feedback\"></span></div><div class=form-group><div vc-recaptcha ng-model=user.captcha theme=light></div></div><div class=\"form-group has-feedback\"><button type=submit ng-disabled=\"user.email == '' || user.captcha == ''\" class=\"btn btn-block btn-default\">Password reset</button></div></form><div class=fusio-login-ruler></div><p class=\"text-center text-muted\"><small><a ng-href=#!/login>Log in</a> if you already have an account</small></p></div>"
  );


  $templateCache.put('app/register/activate.html',
    "<div class=\"container fusio-login-container\"><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">Activation successful. You can now <a ng-href=#!/login>Log in</a> with your new account.</div><div class=fusio-login-ruler></div><p class=\"text-center text-muted\"><small><a ng-href=#!/login>Log in</a> if you already have an account</small></p></div>"
  );


  $templateCache.put('app/register/register.html',
    "<div class=\"container fusio-login-container\"><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">Registration successful. We have send you an activation link to the provided email address.</div><form id=registerForm method=POST ng-submit=register(user) ng-hide=\"response.success == true\"><h1>Sign up</h1><div class=\"form-group has-feedback\"><input class=form-control id=name ng-model=user.name required placeholder=Username> <span class=\"ion-person form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><input type=email class=form-control id=email ng-model=user.email required placeholder=Email> <span class=\"ion-at form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><input type=password class=form-control id=password ng-model=user.password required placeholder=Password> <span class=\"ion-key form-control-feedback\"></span></div><div class=\"form-group has-feedback\"><input type=password class=form-control id=passwordRepeat ng-model=user.passwordRepeat required placeholder=\"Confirm Password\"> <span class=\"ion-key form-control-feedback\"></span></div><div class=form-group ng-if=recaptchaEnabled><div vc-recaptcha ng-model=user.captcha theme=light></div></div><div class=\"form-group has-feedback\"><button type=submit ng-disabled=isRegisterDisabled() class=\"btn btn-block btn-default\">Register</button></div></form><div class=fusio-login-ruler></div><p class=\"text-center text-muted\"><small><a ng-href=#!/login>Log in</a> if you already have an account</small></p></div>"
  );


  $templateCache.put('app/account/app/app.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Apps</h2><div uib-alert ng-class=\"'alert-info'\">List of your apps, through an app you get a consumer key and secret which enables you to access the protected parts of the API. Click on the show button to see the app key and secret.</div><table class=table><colgroup><col width=*><col width=200><col width=200></colgroup><thead><tr><th>Name</th><th>Create date</th><th></th></tr></thead><tbody><tr ng-repeat=\"app in apps\"><td>{{ app.name }}</td><td>{{ app.date | date:'shortDate' }}</td><td><div class=\"btn-group pull-right\" role=group><button class=\"btn btn-default\" ng-click=showApp(app)>Show</button> <button class=\"btn btn-danger\" ng-click=deleteApp(app)>Delete</button></div></td></tr></tbody></table><a ng-click=createApp() class=\"btn btn-primary\" role=button>Create</a></div></div></div>"
  );


  $templateCache.put('app/account/app/create.html',
    "<form name=accountAppForm ng-submit=create(app)><div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{ response.message }}</div><div class=form-group><label for=name>Name:</label> <input id=name ng-model=app.name required class=form-control></div><div class=form-group><label for=url>Url:</label> <input type=url id=url ng-model=app.url required class=form-control></div><div class=checkbox ng-repeat=\"scope in scopes\"><label><input type=checkbox ng-model=app.scopes[$index] ng-true-value=\"'{{ scope.name }}'\" ng-false-value=\"''\"> {{ scope.name }} <span ng-if=scope.description>- {{ scope.description }}</span></label></div></div><div class=modal-footer><button type=submit class=\"btn btn-primary\">Create</button> <button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div></form>"
  );


  $templateCache.put('app/account/app/detail.html',
    "<div class=modal-header><h3 class=modal-title>{{ app.name }}</h3></div><div class=modal-body><dl><dt>Name</dt><dd>{{ app.name }}</dd><dt>Url</dt><dd>{{ app.url }}</dd><dt>Created on</dt><dd>{{ app.date }}</dd><dt>Scopes</dt><dd><span ng-repeat=\"scope in app.scopes\"><span class=\"label label-primary\">{{ scope }}</span>&nbsp;</span></dd></dl><div class=form-group><label for=appKey class=control-label>App key:</label> <input ng-model=app.appKey readonly class=form-control id=appKey></div><div class=form-group><label for=appSecret class=control-label>App secret:</label> <input ng-model=app.appSecret readonly class=form-control id=appSecret></div></div><div class=modal-footer><button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div>"
  );


  $templateCache.put('app/account/contract/contract.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Contracts</h2><div uib-alert ng-class=\"'alert-info'\">List of available contracts.</div><table class=table><colgroup><col width=*><col width=150><col width=100><col width=100><col width=100><col width=50></colgroup><thead><tr><th>Plan</th><th>Period</th><th>Amount</th><th>Points</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"contract in contracts\"><td>{{ contract.plan.name }}</td><td><span ng-switch=contract.period><span ng-switch-when=0>None</span> <span ng-switch-when=1>1 Month</span> <span ng-switch-when=2>3 Month</span> <span ng-switch-when=3>6 Month</span> <span ng-switch-when=4>12 Month</span></span></td><td>{{ contract.amount | currency : symbol : 2 }}</td><td>{{ contract.points }}</td><td>{{ contract.insertDate | date: 'shortDate' }}</td><td><button class=\"btn btn-default\" ng-click=showContract(contract)>Show</button></td></tr></tbody></table></div></div></div>"
  );


  $templateCache.put('app/account/contract/detail.html',
    "<div class=modal-header><h3 class=modal-title>Invoices</h3></div><div class=modal-body><table class=table><colgroup><col width=100><col width=*><col width=100><col width=100></colgroup><thead><tr><th>Status</th><th>Invoice-Id</th><th>Amount</th><th>Date</th></tr></thead><tbody><tr ng-repeat=\"invoice in invoices\"><td><span ng-switch=invoice.status><span ng-switch-when=0><span class=\"label label-info fusio-badge\">Open</span></span> <span ng-switch-when=1><span class=\"label label-success fusio-badge\">Payed</span></span> <span ng-switch-when=2><span class=\"label label-danger fusio-badge\">Deleted</span></span></span></td><td>{{invoice.displayId}}</td><td>{{invoice.amount | currency : symbol : 2}}</td><td>{{invoice.insertDate | date: 'shortDate'}}</td></tr></tbody></table></div><div class=modal-footer><button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div>"
  );


  $templateCache.put('app/account/grant/grant.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Grants</h2><div uib-alert ng-class=\"'alert-info'\">List of apps which you have granted access to your account. You can revoke the access at any time, the app can then no longer access the API on behalf of your account.</div><table class=table><colgroup><col width=*><col width=200><col width=200></colgroup><thead><tr><th>Name</th><th>Granted on</th><th></th></tr></thead><tbody><tr ng-repeat=\"grant in grants\"><td>{{ grant.app.name }}</td><td>{{ grant.createDate | date:'shortDate' }}</td><td><button class=\"btn btn-danger pull-right\" ng-click=deleteGrant(grant)>Revoke</button></td></tr></tbody></table></div></div></div>"
  );


  $templateCache.put('app/account/invoice/invoice.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Invoices</h2><div uib-alert ng-class=\"'alert-info'\">List of available invoices.</div><table class=table><colgroup><col width=100><col width=*><col width=100><col width=100><col width=50></colgroup><thead><tr><th>Status</th><th>Invoice-Id</th><th>Amount</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"invoice in invoices\"><td><span ng-switch=invoice.status><span ng-switch-when=0><span class=\"label label-info fusio-badge\">Open</span></span> <span ng-switch-when=1><span class=\"label label-success fusio-badge\">Payed</span></span> <span ng-switch-when=2><span class=\"label label-danger fusio-badge\">Deleted</span></span></span></td><td>{{invoice.displayId}}</td><td>{{invoice.amount | currency : symbol : 2}}</td><td>{{invoice.insertDate | date: 'shortDate'}}</td><td><button class=\"btn btn-default\" ng-disabled=\"invoice.status != 0 || loading\" ng-click=pay(invoice)>Pay</button></td></tr></tbody></table></div></div></div>"
  );


  $templateCache.put('app/account/invoice/pay.html',
    "<div class=modal-header><h3 class=modal-title>Invoice</h3></div><div class=modal-body><form name=invoicePayForm ng-submit=pay()><div class=form-group><label for=provider>Provider:</label> <select class=form-control id=provider ng-model=provider ng-options=\"provider.key as provider.name for provider in providers\" aria-describedby=providerHelp></select> <span class=help-block id=providerHelp>The payment provider which you want to use pay this invoice.</span></div><div class=fusio-intro-column><h3>Invoice-Id: {{ invoice.displayId }}</h3><dl><dt>Amount</dt><dd>{{invoice.amount | currency : symbol : 2}}</dd><dt>Date</dt><dd>{{invoice.insertDate | date: 'shortDate'}}</dd></dl></div><button type=submit class=\"btn btn-primary\">Pay</button> <button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></form></div>"
  );


  $templateCache.put('app/account/plan/plan.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Purchase</h2><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=transaction.id><div ng-if=\"transaction.status == STATUS_CREATED\">Transaction was created but not approved yet.</div><div ng-if=\"transaction.status == STATUS_APPROVED\">Thank you for the purchase! We have credited <b>{{transaction.plan.points}}</b> points to your account.</div><div ng-if=\"transaction.status == STATUS_FAILED\">Transaction failed. Please contact the support regarding the transaction <code>{{transaction.transactionId}}</code>.</div></div><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert ng-class=\"'alert-info'\">List of plans which can be purchased. Your account receives a specific amount of points which can be used to call routes which cost points.</div><div class=row><div class=col-md-4 ng-repeat=\"plan in plans\"><div class=fusio-intro-column><h3>{{ plan.name }}</h3><dl><dt>Price</dt><dd>{{ plan.price | currency : symbol : 2 }}</dd><dt>Points</dt><dd>{{ plan.points }}</dd><dt ng-if=plan.period>Period</dt><dd ng-if=plan.period><span ng-if=\"plan.period == 1\">Period: monthly</span> <span ng-if=\"plan.period == 2\">Period: quarterly</span> <span ng-if=\"plan.period == 3\">Period: half yearly</span> <span ng-if=\"plan.period == 4\">Period: yearly</span></dd></dl><p>{{ plan.description }}</p><a ng-click=purchase(plan) ng-class=\"{'disabled': loading}\" class=\"btn btn-primary\">Purchase</a></div></div></div></div></div></div>"
  );


  $templateCache.put('app/account/plan/purchase.html',
    "<div class=modal-header><h3 class=modal-title>Purchase</h3></div><div class=modal-body><form name=planPurchaseForm ng-submit=purchase()><div class=form-group><label for=provider>Provider:</label> <select class=form-control id=provider ng-model=provider ng-options=\"provider.key as provider.name for provider in providers\" aria-describedby=providerHelp></select> <span class=help-block id=providerHelp>The payment provider which you want to use to purchase this payment.</span></div><div class=fusio-intro-column><h3>{{ plan.name }}</h3><dl><dt>Price</dt><dd>{{ plan.price | currency : symbol : 2 }}</dd><dt>Points</dt><dd>{{ plan.points }}</dd><dt ng-if=plan.period>Period</dt><dd ng-if=plan.period><span ng-if=\"plan.period == 1\">Period: monthly</span> <span ng-if=\"plan.period == 2\">Period: quarterly</span> <span ng-if=\"plan.period == 3\">Period: half yearly</span> <span ng-if=\"plan.period == 4\">Period: yearly</span></dd></dl><p>{{ plan.description }}</p></div><button type=submit class=\"btn btn-primary\">Purchase</button> <button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></form></div>"
  );


  $templateCache.put('app/account/profile/profile.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Profile</h2><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div ng-if=account.email class=\"pull-right visible-lg-block visible-md-block\"><img gravatar-src=account.email gravatar-size=100></div><form style=max-width:400px; ng-submit=update(account)><div class=form-group><label for=username>Username</label> <input ng-model=account.name readonly id=username class=form-control></div><div class=form-group><label for=email>Email</label> <input ng-model=account.email id=email class=form-control></div><div class=form-group><label for=points>Points</label> <input type=number ng-model=account.points readonly id=points class=form-control></div><div class=form-group><label for=points>Scopes</label> <input value=\"{{account.scopes.join(',')}}\" readonly id=scopes class=form-control></div><input type=submit class=\"btn btn-primary\" value=Update></form></div></div></div>"
  );


  $templateCache.put('app/account/security/security.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Security</h2><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert ng-class=\"'alert-success'\" close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><form style=max-width:400px; ng-submit=update(account)><div class=form-group><label for=oldPassword>Old password:</label> <input type=password id=oldPassword ng-model=account.oldPassword aria-describedby=oldPasswordHelp required minlength=8 maxlength=128 class=form-control> <span class=help-block id=oldPasswordHelp></span></div><div class=form-group><label for=newPassword>New password:</label> <input type=password id=newPassword ng-model=account.newPassword aria-describedby=newPasswordHelp required minlength=8 maxlength=128 class=form-control> <span class=help-block id=newPasswordHelp></span></div><div class=form-group><label for=verifyPassword>Verify password:</label> <input type=password id=verifyPassword ng-model=account.verifyPassword aria-describedby=verifyPasswordHelp required minlength=8 maxlength=128 class=form-control> <span class=help-block id=verifyPasswordHelp></span></div><button type=submit class=\"btn btn-primary\">Change password</button></form></div></div></div>"
  );


  $templateCache.put('app/account/subscription/create.html',
    "<form name=accountSubscriptionForm ng-submit=create(subscription)><div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert ng-class=\"'alert-danger'\" close=closeResponse() ng-if=\"response.success === false\">{{ response.message }}</div><div class=form-group><label for=event>Event:</label> <select id=event ng-model=subscription.event ng-options=\"event.name as event.name for event in events\" required aria-describedby=eventHelp class=form-control></select> <span class=help-block id=eventHelp>The event which you can subscribe.</span></div><div class=form-group><label for=url>Endpoint:</label> <input type=url id=url ng-model=subscription.endpoint required aria-describedby=urlHelp class=form-control> <span class=help-block id=urlHelp>The endpoint which is called if the event occurs.</span></div></div><div class=modal-footer><button type=submit class=\"btn btn-primary\">Create</button> <button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div></form>"
  );


  $templateCache.put('app/account/subscription/detail.html',
    "<div class=modal-header><h3 class=modal-title>{{ subscription.event }}</h3></div><div class=modal-body><dl><dt>Event</dt><dd>{{ subscription.event }}</dd><dt>Endpoint</dt><dd>{{ subscription.endpoint }}</dd></dl><table class=table><thead><tr><th>Status</th><th>Code</th><th>Attempts</th><th>Date</th></tr></thead><tbody><tr ng-repeat=\"response in subscription.responses\"><td><span class=\"label label-info\" ng-if=\"response.status == 1\">Pending</span> <span class=\"label label-success\" ng-if=\"response.status == 2\">Done</span> <span class=\"label label-danger\" ng-if=\"response.status == 3\">Error</span></td><td>{{ response.code }}</td><td>{{ response.attempts }}</td><td>{{ response.executeDate | date:'shortDate' }}</td></tr></tbody></table></div><div class=modal-footer><button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div>"
  );


  $templateCache.put('app/account/subscription/subscription.html',
    "<div class=row><div class=\"col-md-2 fusio-sidebar\" ng-include src=\"'app/account/nav.html'\"></div><div class=col-md-10><div class=fusio-content><h2>Subscriptions</h2><div uib-alert ng-class=\"'alert-info'\">List of subscriptions. The API provider can define specific events which you can subscribe to. If such an event occurs the endpoint will receive an HTTP POST request with the provided payload.</div><table class=table><colgroup><col width=*><col width=200><col width=200></colgroup><thead><tr><th>Event</th><th>Endpoint</th><th></th></tr></thead><tbody><tr ng-repeat=\"subscription in subscriptions\"><td>{{ subscription.event }}</td><td>{{ subscription.endpoint }}</td><td><div class=\"btn-group pull-right\" role=group><button class=\"btn btn-default\" ng-click=showSubscription(subscription)>Show</button> <button class=\"btn btn-danger\" ng-click=deleteSubscription(subscription)>Delete</button></div></td></tr></tbody></table><a ng-click=createSubscription() class=\"btn btn-primary\" role=button>Subscribe</a></div></div></div>"
  );

}]);
