angular.module('evid').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('app/partials/api.html',
    "<md-content class=evid-api><md-toolbar class=\"md-toolbar-tools md-hue-2\"><h2>{{ api.path }}</h2><span flex></span><md-button aria-label=\"Send request\" class=\"md-icon-button evid-api-export\" ng-click=showConsole()><md-icon md-menu-origin md-font-library=material-icons>send</md-icon></md-button><md-menu ng-if=\"api.links && api.links.length > 0\"><md-button aria-label=\"Export schema\" class=\"md-icon-button evid-api-export\" ng-click=$mdMenu.open($event)><md-icon md-menu-origin md-font-library=material-icons>archive</md-icon></md-button><md-menu-content width=3><md-menu-item ng-repeat=\"link in api.links\"><md-button ng-href=\"{{ link.href }}\" target=_blank>{{ link.rel|ucfirst }}</md-button></md-menu-item></md-menu-content></md-menu></md-toolbar><div ng-if=api.description class=evid-api-description marked=api.description></div><md-tabs md-dynamic-height md-selected=selectedMethod md-border-bottom><md-tab ng-repeat=\"(methodName, method) in methods\" label=\"{{ methodName }}\"><md-content ng-bind-html=method flex></md-content><div ng-if=examples[methodName] class=evid-api-examples><md-toolbar class=md-accent><div class=md-toolbar-tools><h2>Examples</h2></div></md-toolbar><md-tabs><md-tab ng-repeat=\"(lang, row) in examples[methodName]\" label=\"{{ lang }}\"><div ng-repeat=\"(type, example) in row track by $index\"><md-subheader class=\"md-primary md-subheader\">{{ type|ucfirst }}</md-subheader><div hljs language=\"{{ lang }}\" source=example class=evid-api-example-source></div></div></md-tab></md-tabs></div></md-tab></md-tabs></md-content>"
  );


  $templateCache.put('app/partials/console.html',
    "<md-dialog aria-label=Console style=width:800px;><md-toolbar class=md-toolbar-tools><h2>{{ request.method }}</h2></md-toolbar><md-dialog-content class=\"evid-console md-padding\"><div layout=row><md-input-container class=md-block flex=66><label>URL</label> <input ng-model=request.url></md-input-container><md-input-container class=md-block flex=33><label>Access-Token (OAuth2)</label> <input ng-model=request.accessToken></md-input-container></div><md-input-container ng-if=\"request.method == 'POST' || request.method == 'PUT'\" class=md-block><label>Body</label> <textarea ng-model=request.body class=evid-console-body></textarea></md-input-container><md-subheader class=md-primary ng-if=response.statusCode>{{ response.statusCode }} {{ response.statusText }}</md-subheader><div ng-if=loading layout=row layout-sm=column layout-align=space-around><md-progress-circular md-mode=indeterminate></md-progress-circular></div><div ng-if=!loading><div hljs language=json source=response.body ng-if=response.body></div></div></md-dialog-content><div class=md-actions layout=row><md-button class=\"md-raised md-primary\" ng-click=sendRequest()>Send</md-button></div></md-dialog>"
  );


  $templateCache.put('app/partials/page.html',
    "<md-content><md-toolbar class=\"md-toolbar-tools md-hue-2\"><h2>{{ title }}</h2></md-toolbar><ng-include src=href></ng-include></md-content>"
  );

}]);
