angular.module('fusioApp').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('app/controller/account/change_password.html',
    "<h1>Account / Change password</h1><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><form name=changePasswordForm ng-submit=updatePassword() style=max-width:400px;><div class=form-group><label for=oldPassword>Old password:</label> <input type=password id=oldPassword ng-model=account.oldPassword aria-describedby=oldPasswordHelp required minlength=8 maxlength=128 class=form-control> <span class=help-block id=oldPasswordHelp></span></div><div class=form-group><label for=newPassword>New password:</label> <input type=password id=newPassword ng-model=account.newPassword aria-describedby=newPasswordHelp required minlength=8 maxlength=128 class=form-control> <span class=help-block id=newPasswordHelp></span></div><div class=form-group><label for=verifyPassword>Verify password:</label> <input type=password id=verifyPassword ng-model=account.verifyPassword aria-describedby=verifyPasswordHelp required minlength=8 maxlength=128 class=form-control> <span class=help-block id=verifyPasswordHelp></span></div><button type=submit class=\"btn btn-primary\">Change password</button></form>"
  );


  $templateCache.put('app/controller/action/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=actionCreateForm ng-submit=create(action)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=action.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the action must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=class>Class:</label><div class=input-group><input ng-model=action.class ng-change=loadConfig() ng-if=custom aria-describedby=classHelp class=\"form-control no-animate\"> <select id=class ng-model=action.class ng-change=loadConfig() ng-if=!custom ng-options=\"action.class as action.name for action in actions\" aria-describedby=classHelp class=\"form-control no-animate\"></select><div class=input-group-btn><button class=\"btn btn-default\" type=button ng-click=\"custom = !custom\"><span class=\"glyphicon glyphicon-pencil\" aria-hidden=true></span></button></div></div><span class=help-block id=classHelp>Action class which gets executed. Each action can provide additional configuration parameters which are loaded if a class was selected</span></div><div class=form-group><label for=async>Async:</label><br><input type=checkbox id=async ng-model=action.async aria-describedby=asyncHelp> <span class=help-block id=asyncHelp>Whether to execute the action in async mode. In async mode the action gets executed in the background this is useful i.e. for expensive actions.</span></div><div id=config-form></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=showHelp() class=\"btn btn-default fusio-btn-help\">Help</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/action/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=actionDeleteForm ng-submit=delete(action)><input type=hidden ng-model=action.id value={{action.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=action.name ng-disabled=true class=form-control value={{action.name}}></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/action/designer.html',
    "<h1><a ng-href=#!/action>Action</a> / Designer</h1><div class=row><div class=col-md-6><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><uib-accordion close-others=false><div uib-accordion-group class=panel-default heading=Action is-open=true><form name=actionDesignerForm ng-submit=\"update(action, request)\" class=fusio-action-designer-config><input type=hidden ng-model=action.id value={{action.id}}><div id=config-form></div><button type=submit class=\"btn btn-primary\">Execute</button></form></div></uib-accordion></div><div class=col-md-6><uib-accordion close-others=false><div uib-accordion-group class=panel-default heading=Request is-open=true><form class=fusio-action-designer-request><div class=form-group><label for=requestMethod>Method:</label> <select id=requestMethod ng-model=request.method ng-options=\"method for method in methods\" aria-describedby=requestMethodHelp class=form-control></select> <span class=help-block id=requestMethodHelp>The request method of the HTTP request</span></div><div class=form-group><label for=requestUriFragments>URI Fragments:</label> <input id=requestUriFragments ng-model=request.uriFragments aria-describedby=requestUriFragmentsHelp class=form-control> <span class=help-block id=requestUriFragmentsHelp>Optional the available uri fragments i.e. <code>news_id=10&count=10</code></span></div><div class=form-group><label for=requestParameters>Parameters:</label> <input id=requestParameters ng-model=request.parameters aria-describedby=requestParametersHelp class=form-control> <span class=help-block id=requestParametersHelp>Optional the available parameters i.e. <code>count=10&completed=true</code></span></div><div class=form-group><label for=requestHeaders>Headers:</label> <input id=requestHeaders ng-model=request.headers aria-describedby=requestHeadersHelp class=form-control> <span class=help-block id=requestHeadersHelp>Optional request headers i.e. <code>Content-Type=application/json</code></span></div><div class=form-group><label for=requestBody>Body:</label><div ui-ace=\"{mode: 'json'}\" id=requestBody ng-model=request.body aria-describedby=requestBodyHelp></div><span class=help-block id=requestBodyHelp>The JSON data of the request body</span></div></form></div></uib-accordion></div></div><div class=row><div class=col-md-12><uib-accordion close-others=false><div uib-accordion-group class=panel-default heading=\"Response {{ response.statusCode }}\" is-open=true ng-if=response.statusCode><div ng-if=error.message class=\"fusio-action-designer-response alert-danger\"><h4>{{error.message}}</h4><pre style=\"padding:8px;border-bottom:1px solid #aaa\">{{error.trace}}</pre></div><div ng-if=!error.message class=fusio-action-designer-response><pre>{{ response.body }}</pre></div></div></uib-accordion></div></div>"
  );


  $templateCache.put('app/controller/action/index.html',
    "<h1>Action</h1><div class=fusio-search><form name=actionSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. action-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('api/action')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=row><div class=col-md-2><div class=\"panel panel-default\"><div class=panel-heading>Action</div><div class=panel-body><div class=fusio-route-navigation><ul><li ng-repeat=\"row in actions\"><a ng-href=#!/action/{{row.id}} title={{row.name}}><b ng-if=\"action.name == row.name\">{{row.name}}</b> <span ng-if=\"action.name != row.name\">{{row.name}}</span></a></li></ul></div><ul uib-pager total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul></div></div></div><div class=col-md-10><div class=\"panel panel-default\"><div class=panel-heading>&nbsp;{{action.name}}</div><div class=panel-body><div class=btn-group role=group><button type=button ng-click=openUpdateDialog(action) class=\"btn btn-primary fusio-btn-update\">Edit</button> <a ng-href=#!/action/designer/{{action.id}} class=\"btn btn-default fusio-btn-ui\">Designer</a> <button type=button ng-click=openDeleteDialog(action) class=\"btn btn-danger fusio-btn-delete\">Delete</button></div><br><br><div class=form-group ng-if=action.name><label>Name:</label><div class=row><div class=col-md-12><p>{{action.name}}</p></div></div></div><div class=form-group ng-if=action.class><label>Class:</label><div class=row><div class=col-md-12><code>{{action.class}}</code></div></div></div><div class=form-group ng-if=action.engine><label>Engine:</label><div class=row><div class=col-md-12><code>{{action.engine}}</code></div></div></div><div class=form-group ng-if=action.config><label>Config:</label><div class=row><div class=col-md-12><pre>{{action.config}}</pre></div></div></div></div></div></div></div>"
  );


  $templateCache.put('app/controller/action/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=actionUpdateForm ng-submit=update(action)><input type=hidden ng-model=action.id value={{action.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=action.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the action must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=class>Class:</label> <input id=class ng-model=action.class class=form-control value={{action.class}} disabled aria-describedby=classHelp> <span class=help-block id=classHelp>Action class which gets executed</span></div><div class=form-group><label for=async>Async:</label><br><input type=checkbox id=async ng-model=action.async aria-describedby=asyncHelp> <span class=help-block id=asyncHelp>Whether to execute the action in async mode. In async mode the action gets executed in the background this is useful i.e. for expensive actions.</span></div><div id=config-form></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=showHelp() class=\"btn btn-default fusio-btn-help\">Help</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/app/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesCreateForm ng-submit=create(app)><div class=form-group><label for=status>Status:</label> <select id=status ng-model=app.status ng-options=\"state.key as state.value for state in states\" aria-describedby=statusHelp class=form-control></select> <span class=help-block id=statusHelp>The status of the app. Only apps which are <b>Active</b> can request an access token for the API</span></div><div class=form-group><label for=user>User:</label> <select id=user ng-model=app.userId ng-options=\"user.id as user.name for user in users\" class=form-control aria-describedby=userHelp></select> <span class=help-block id=userHelp>The user which is assigned to the application</span></div><div class=form-group><label for=name>Name:</label> <input id=name ng-model=app.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the app must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code> application</span></div><div class=form-group><label for=url>Url:</label> <input id=url ng-model=app.url aria-describedby=urlHelp class=form-control> <span class=help-block id=urlHelp>Optional url of the application</span></div><div class=form-group><label for=parameters>Parameters:</label> <input id=parameters ng-model=app.parameters aria-describedby=parametersHelp class=form-control> <span class=help-block id=parametersHelp>Optional parameters of the application i.e. <code>premium=1&amp;blocked=no</code>. These parameters can be used inside an action to change the behaviour depending on the app.</span></div><uib-tabset><uib-tab heading=\"{{ category.name }}\" ng-repeat=\"category in categories\"><table class=\"table fusio-table-tab\"><colgroup><col width=20><col width=*></colgroup><tbody><tr ng-repeat=\"scope in category.scopes\"><td><input type=checkbox value={{scope.name}} id=scope-{{scope.id}} ng-checked=\"selected.indexOf(scope.name) > -1\" ng-click=toggleScope(scope.name)></td><td><label for=scope-{{scope.id}}>{{scope.name}}</label></td></tr></tbody></table></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/app/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesDeleteForm ng-submit=delete(app)><input type=hidden ng-model=app.id value={{app.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=app.name ng-disabled=true class=form-control></div><div class=form-group><label for=appKey>App-Key:</label> <input id=appKey ng-model=app.appKey ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/app/index.html',
    "<h1>App</h1><div class=fusio-search><form name=appsSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. app-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('consumer/app')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=400><col width=100></colgroup><thead><tr><th>Name</th><th>App-Key</th><th></th></tr></thead><tbody><tr ng-repeat=\"app in apps\"><td>{{app.name}}</td><td>{{app.appKey}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(app) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(app) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/app/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesUpdateForm ng-submit=update(app)><input type=hidden ng-model=app.id value={{app.id}}><div class=form-group><label for=status>Status:</label> <select id=status ng-model=app.status ng-options=\"state.key as state.value for state in states\" aria-describedby=statusHelp class=form-control></select> <span class=help-block id=statusHelp>The status of the app. Only apps which are <b>Active</b> can request an access token for the API</span></div><div class=form-group><label for=name>Name:</label> <input id=name ng-model=app.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the app must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code> application</span></div><div class=form-group><label for=url>Url:</label> <input id=url ng-model=app.url aria-describedby=urlHelp class=form-control> <span class=help-block id=urlHelp>Optional url of the application</span></div><div class=form-group><label for=parameters>Parameters:</label> <input id=parameters ng-model=app.parameters aria-describedby=parametersHelp class=form-control> <span class=help-block id=parametersHelp>Optional parameters of the application i.e. <code>premium=1&amp;blocked=no</code>. These parameters can be used inside an action to change the behaviour depending on the app.</span></div><div class=form-group><label for=appKey>App-Key:</label> <input id=appKey ng-model=app.appKey class=form-control readonly></div><div class=form-group><label for=appSecret>App-Secret:</label> <input id=appSecret ng-model=app.appSecret class=form-control readonly></div><uib-tabset><uib-tab heading=\"{{ category.name }}\" ng-repeat=\"category in categories\"><table class=\"table fusio-table-tab\"><colgroup><col width=20><col width=*></colgroup><tbody><tr ng-repeat=\"scope in category.scopes\"><td><input type=checkbox value={{scope.name}} id=scope-{{scope.id}} ng-checked=\"selected.indexOf(scope.name) > -1\" ng-click=toggleScope(scope.name)></td><td><label for=scope-{{scope.id}}>{{scope.name}}</label></td></tr></tbody></table></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/audit/detail.html',
    "<div class=modal-header><h3 class=modal-title>Detail</h3></div><div class=modal-body><uib-accordion close-others=false><div uib-accordion-group class=panel-default heading=Log is-open=true><form name=auditDetailForm><div class=form-group><label for=app>App:</label> <input id=app ng-model=audit.app.name ng-disabled=true class=form-control></div><div class=form-group><label for=user>User:</label> <input id=user ng-model=audit.user.name ng-disabled=true class=form-control></div><div class=form-group><label for=refId>Reference:</label> <input id=refId ng-model=audit.refId ng-disabled=true class=form-control></div><div class=form-group><label for=event>Event:</label> <input id=event ng-model=audit.event ng-disabled=true class=form-control></div><div class=form-group><label for=ip>IP:</label> <input id=ip ng-model=audit.ip ng-disabled=true class=form-control></div><div class=form-group><label for=message>Message:</label> <input id=message ng-model=audit.message ng-disabled=true class=form-control></div><div class=form-group><label for=date>Date:</label> <input id=date ng-model=audit.date ng-disabled=true class=form-control></div></form></div><div uib-accordion-group class=panel-default heading=Content is-open=false><pre class=fusio-audit-detail-content>{{audit.content | json}}</pre></div></uib-accordion><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/audit/filter.html',
    "<div class=modal-header><h3 class=modal-title>Filter</h3></div><div class=modal-body><form name=statisticFilterForm ng-submit=doFilter()><div class=form-group><label for=from>Date from/to:</label><div class=row><div class=col-md-6><input id=from type=date ng-model=filter.from required class=form-control aria-describedby=fromHelp></div><div class=col-md-6><input id=to type=date ng-model=filter.to required class=form-control aria-describedby=toHelp></div></div></div><div class=form-group><label for=app>App:</label> <select id=app ng-model=filter.appId ng-options=\"app.id as app.name for app in apps\" class=form-control aria-describedby=appHelp><option value=\"\">Every app</option><option value=-1>Anonymous</option></select> <span class=help-block id=appHelp></span></div><div class=form-group><label for=user>User:</label> <select id=user ng-model=filter.userId ng-options=\"user.id as user.name for user in users\" class=form-control aria-describedby=userHelp><option value=\"\">Every user</option></select> <span class=help-block id=userHelp></span></div><div class=form-group><label for=event>Event:</label> <input id=event ng-model=filter.event class=form-control aria-describedby=eventHelp> <span class=help-block id=eventHelp></span></div><div class=form-group><label for=ip>IP:</label> <input id=ip ng-model=filter.ip class=form-control aria-describedby=ipHelp> <span class=help-block id=ipHelp></span></div><div class=form-group><label for=message>Message:</label> <input id=message ng-model=filter.message class=form-control aria-describedby=messageHelp> <span class=help-block id=messageHelp></span></div><button type=submit class=\"btn btn-primary fusio-btn-filter\">Filter</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/audit/index.html',
    "<h1>Audit</h1><div class=fusio-search><form name=logsSearchForm ng-submit=doFilter(filter)><div class=input-group><input class=form-control ng-model=filter.search placeholder=\"Search i.e. /foo/bar\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-filter\" ng-click=openFilterDialog()><span class=\"glyphicon glyphicon-filter\" aria-hidden=true></span></a></div></div></form></div><div class=fusio-grid><table class=table><colgroup><col width=200><col width=*><col width=150><col width=150><col width=50></colgroup><thead><tr><th>Event</th><th>Message</th><th>IP</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"audit in audits\"><td>{{audit.event}}</td><td>{{audit.message}}</td><td>{{audit.ip}}</td><td>{{audit.date | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(audit) class=\"btn btn-default fusio-btn-detail\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/category/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=categoryCreateForm ng-submit=create(category)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=category.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/category/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=categoryDeleteForm ng-submit=delete(category)><input type=hidden ng-model=category.id value={{category.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=category.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/category/index.html',
    "<h1>Category</h1><div class=fusio-search><form name=categorySearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. category-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('system/category')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=100></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"category in categories\"><td>{{category.name}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(category) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(category) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/category/update.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=categoryUpdateForm ng-submit=update(category)><input type=hidden ng-model=category.id value={{category.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=category.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/config/index.html',
    "<h1>Settings</h1><div class=fusio-search><form name=configSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. config-name\"><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('system/settings')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=200><col width=*><col width=50></colgroup><thead><tr><th>Name</th><th>Description</th><th></th></tr></thead><tbody><tr ng-repeat=\"config in configs\"><td>{{config.name}}</td><td>{{config.description}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(config) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/config/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=configUpdateForm ng-submit=update(config)><input type=hidden ng-model=config.id value={{config.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=config.name readonly aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><div class=form-group><label for=name>Value:</label><div ng-if=\"config.type == 1\"><input ng-model=config.value aria-describedby=valueHelp class=form-control></div><div ng-if=\"config.type == 2\"><input type=checkbox ng-model=config.value aria-describedby=valueHelp></div><div ng-if=\"config.type == 3\"><input type=number ng-model=config.value aria-describedby=valueHelp class=form-control></div><div ng-if=\"config.type == 4\"><input type=datetime ng-model=config.value aria-describedby=valueHelp class=form-control></div><div ng-if=\"config.type == 5\"><input type=email ng-model=config.value aria-describedby=valueHelp class=form-control></div><div ng-if=\"config.type == 6\"><textarea ng-model=config.value rows=6 aria-describedby=valueHelp class=form-control></textarea></div><div ng-if=\"config.type == 7\"><input type=password ng-model=config.value aria-describedby=valueHelp class=form-control></div><span class=help-block id=valueHelp></span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/connection/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesCreateForm ng-submit=create(connection)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=connection.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the connection must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=class>Class:</label><div class=input-group><input ng-model=connection.class ng-change=loadConfig() ng-if=custom aria-describedby=classHelp class=\"form-control no-animate\"> <select id=class ng-model=connection.class ng-change=loadConfig() ng-if=!custom ng-options=\"conn.class as conn.name for conn in connections\" aria-describedby=classHelp class=\"form-control no-animate\"></select><div class=input-group-btn><button class=\"btn btn-default\" type=button ng-click=\"custom = !custom\"><span class=\"glyphicon glyphicon-pencil\" aria-hidden=true></span></button></div></div><span class=help-block id=classHelp>Connection class which gets executed. Each connection can provide aditional configuration parameters which are loaded if an class was selected</span></div><div id=config-form></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=showHelp() class=\"btn btn-default fusio-btn-help\">Help</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/connection/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesDeleteForm ng-submit=delete(connection)><input type=hidden ng-model=connection.id value={{connection.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=connection.name ng-disabled=true class=form-control value={{connection.name}}></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/connection/index.html',
    "<h1>Connection</h1><div class=fusio-search><form name=connectionsSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. connection-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('api/connection')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=100></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"connection in connections\"><td>{{connection.name}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(connection) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(connection) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/connection/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesUpdateForm ng-submit=update(connection)><input type=hidden ng-model=connection.id value={{connection.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=connection.name aria-describedby=nameHelp class=form-control value={{connection.name}} disabled> <span class=help-block id=nameHelp>Name of the connection must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=class>Class:</label> <input id=class ng-model=connection.class class=form-control value={{connection.class}} disabled></div><div id=config-form></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button ng-if=connection.oauth2 type=button ng-click=authorize() class=\"btn btn-default fusio-btn-authorize\">Authorize</button> <button type=button ng-click=showHelp() class=\"btn btn-default fusio-btn-help\">Help</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/contract/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=planCreateForm ng-submit=create(contract)><div class=form-group><label for=user>User:</label> <select id=user ng-model=contract.userId ng-options=\"user.id as user.name for user in users\" class=form-control aria-describedby=userHelp></select> <span class=help-block id=userHelp>The user which is assigned to the contract</span></div><div class=form-group><label for=plan>Plan:</label> <select id=plan ng-model=contract.planId ng-options=\"plan.id as plan.name for plan in plans\" class=form-control aria-describedby=planHelp></select> <span class=help-block id=planHelp>The plan for the contract</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/contract/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=contractDeleteForm ng-submit=delete(contract)><input type=hidden ng-model=contract.id value={{contract.id}}><div class=form-group><label for=user>User:</label> <input id=user ng-model=contract.user.name ng-disabled=true class=form-control></div><div class=form-group><label for=plan>Plan:</label> <input id=plan ng-model=contract.plan.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/contract/index.html',
    "<h1>Plan</h1><div class=fusio-search><form name=contractSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. contract-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('monetization/contract')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=200><col width=150><col width=150><col width=150><col width=100></colgroup><thead><tr><th>User</th><th>Plan</th><th>Amount</th><th>Points</th><th>Period</th><th></th></tr></thead><tbody><tr ng-repeat=\"contract in contracts\"><td>{{contract.user.name}}</td><td>{{contract.plan.name}}</td><td>{{contract.amount | currency : symbol : 2}}</td><td>{{contract.points}}</td><td><span ng-switch=contract.period><span ng-switch-when=0>None</span> <span ng-switch-when=1>1 Month</span> <span ng-switch-when=2>3 Month</span> <span ng-switch-when=3>6 Month</span> <span ng-switch-when=4>12 Month</span></span></td><td><div class=fusio-options><a ng-click=openDeleteDialog(contract) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/cronjob/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesCreateForm ng-submit=create(cronjob)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=cronjob.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the cronjob must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=cron>Cron:</label> <input id=cron ng-model=cronjob.cron aria-describedby=cronHelp class=form-control> <span class=help-block id=cronHelp><a href=https://wikipedia.org/wiki/Cron>Cron expression</a> i.e. <code>0 0 * * *</code> to execute the action every day</span></div><div class=form-group><label>Action:</label> <select class=form-control ng-model=cronjob.action ng-options=\"action.name as action.name for action in actions\" aria-describedby=actionHelp></select> <span class=help-block id=actionHelp>The action which gets executed</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/cronjob/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesDeleteForm ng-submit=delete(cronjob)><input type=hidden ng-model=cronjob.id value={{cronjob.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=cronjob.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/cronjob/error.html',
    "<div class=modal-header><h3 class=modal-title>Error</h3></div><div class=modal-body><div ng-if=\"cronjob.errors.length > 0\"><div class=fusio-grid><table class=table><colgroup><col width=*><col width=50></colgroup><thead><tr><th>Message</th><th></th></tr></thead><tbody><tr ng-repeat=\"error in cronjob.errors\"><td>{{error.message}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(error) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-search\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><br></div><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/cronjob/index.html',
    "<h1>Cronjob</h1><div class=fusio-search><form name=scopesSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. cronjob-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('api/cronjob')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=300><col width=100><col width=150><col width=100></colgroup><thead><tr><th>Name</th><th>Cron</th><th>Exit code</th><th>Last execution</th><th></th></tr></thead><tbody><tr ng-repeat=\"cronjob in cronjobs\"><td>{{cronjob.name}}</td><td>{{cronjob.cron}}</td><td><a ng-if=\"cronjob.exitCode == 0\"><span class=\"glyphicon glyphicon-ok\" style=color:green aria-hidden=true></span></a> <a ng-if=\"cronjob.exitCode == 1\" ng-click=openErrorDialog(cronjob) style=cursor:pointer><span class=\"glyphicon glyphicon-remove\" style=color:red aria-hidden=true></span></a></td><td>{{cronjob.executeDate | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(cronjob) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(cronjob) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/cronjob/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesUpdateForm ng-submit=update(cronjob)><input type=hidden ng-model=cronjob.id value={{cronjob.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=cronjob.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the cronjob must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=cron>Cron:</label> <input id=cron ng-model=cronjob.cron aria-describedby=cronHelp class=form-control> <span class=help-block id=cronHelp><a href=https://wikipedia.org/wiki/Cron>Cron expression</a> i.e. <code>0 0 * * *</code> to execute the action every day</span></div><div class=form-group><label>Action:</label><div class=row><div class=col-md-12><select class=form-control ng-model=cronjob.action ng-options=\"action.name as action.name for action in actions\" aria-describedby=actionHelp><option value=\"\">No action</option></select></div></div><span class=help-block id=actionHelp>The action which gets executed</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/dashboard/index.html',
    "<h1>Dashboard</h1><div class=row><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Incoming request chart</div><div class=panel-body><canvas class=\"chart chart-line\" height=220 chart-options=\"{'responsive':true,'maintainAspectRatio':false}\" chart-data=incomingRequests.data chart-labels=incomingRequests.labels chart-series=incomingRequests.series></canvas></div></div></div><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Most used routes</div><div class=panel-body><canvas class=\"chart chart-line\" height=220 chart-options=\"{'responsive':true,'maintainAspectRatio':false}\" chart-data=mostUsedRoutes.data chart-labels=mostUsedRoutes.labels chart-series=mostUsedRoutes.series></canvas></div></div></div><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Execution time per route (ms)</div><div class=panel-body><canvas class=\"chart chart-line\" height=220 chart-options=\"{'responsive':true,'maintainAspectRatio':false}\" chart-data=timePerRoute.data chart-labels=timePerRoute.labels chart-series=timePerRoute.series></canvas></div></div></div></div><div class=row><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Latest users</div><div class=panel-body><table class=table><tbody><tr ng-repeat=\"user in latestUsers\"><td>{{user.name}}</td></tr></tbody></table></div></div></div><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Errors per route</div><div class=panel-body><canvas class=\"chart chart-line\" height=220 chart-options=\"{'responsive':true,'maintainAspectRatio':false}\" chart-data=errorsPerRoute.data chart-labels=errorsPerRoute.labels chart-series=errorsPerRoute.series></canvas></div></div></div><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Incoming transactions</div><div class=panel-body><canvas class=\"chart chart-line\" height=220 chart-options=\"{'responsive':true,'maintainAspectRatio':false}\" chart-data=incomingTransactions.data chart-labels=incomingTransactions.labels chart-series=incomingTransactions.series></canvas></div></div></div></div><div class=row><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Latest requests</div><div class=panel-body><table class=table><tbody><tr ng-repeat=\"request in latestRequests\"><td>{{request.path}}</td></tr></tbody></table></div></div></div><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Latest apps</div><div class=panel-body><table class=table><tbody><tr ng-repeat=\"app in latestApps\"><td>{{app.name}}</td></tr></tbody></table></div></div></div><div class=col-md-4><div class=\"panel panel-default fusio-panel\"><div class=panel-heading>Latest transactions</div><div class=panel-body><table class=table><tbody><tr ng-repeat=\"transaction in latestTransactions\"><td>{{transaction.transactionId}}</td><td>{{transaction.amount | currency : symbol : 2}}</td></tr></tbody></table></div></div></div></div>"
  );


  $templateCache.put('app/controller/error/detail.html',
    "<div class=modal-header><h3 class=modal-title>Error</h3></div><div class=modal-body><uib-accordion close-others=false><div uib-accordion-group class=panel-default heading=Error is-open=true><b class=fusio-error-detail-message>{{error.message}}</b><p>in <span class=fusio-error-detail-file>{{error.file}}</span> on <span class=fusio-error-detail-line>{{error.line}}</span></p></div><div uib-accordion-group class=panel-default heading=Trace is-open=true><pre class=fusio-error-detail-trace>{{error.trace}}</pre></div></uib-accordion><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/error/index.html',
    "<h1>Error</h1><div class=fusio-search><form name=errorsSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. message\"><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('analytics/error')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=150><col width=150><col width=50></colgroup><thead><tr><th>Message</th><th>Path</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"error in errors\"><td>{{error.message}}</td><td><div style=overflow:hidden;width:150px;white-space:nowrap; title={{error.path}}>{{error.path}}</div></td><td>{{error.date | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(error) class=\"btn btn-default fusio-btn-detail\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/event/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=eventCreateForm ng-submit=create(event)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=event.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the event must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=description>Description:</label> <textarea type=text id=description ng-model=event.description rows=3 aria-describedby=descriptionHelp class=form-control></textarea> <span class=help-block id=descriptionHelp>General description of this event</span></div><div class=form-group><label for=schema>Schema:</label> <select class=form-control id=schema ng-model=event.schema ng-options=\"schema.name as schema.name for schema in schemas\" aria-describedby=schemaHelp><option value=\"\">No schema</option></select> <span class=help-block id=schemaHelp>Schema which describe the payload of the event</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/event/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=eventDeleteForm ng-submit=delete(event)><input type=hidden ng-model=event.id value={{event.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=event.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/event/index.html',
    "<h1>Event</h1><div class=fusio-search><form name=eventSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. event-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('api/event')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=150></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"event in events\"><td>{{event.name}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(event) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(event) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/event/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=eventUpdateForm ng-submit=update(event)><input type=hidden ng-model=event.id value={{event.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=event.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the event must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=description>Description:</label> <textarea type=text id=description ng-model=event.description rows=3 aria-describedby=descriptionHelp class=form-control></textarea> <span class=help-block id=descriptionHelp>General description of this event</span></div><div class=form-group><label for=schema>Schema:</label> <select class=form-control id=schema ng-model=event.schema ng-options=\"schema.name as schema.name for schema in schemas\" aria-describedby=schemaHelp><option value=\"\">No schema</option></select> <span class=help-block id=schemaHelp>Schema which describe the payload of the event</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/invoice/index.html',
    "<h1>Plan</h1><div class=fusio-search><form name=invoiceSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. invoice-id\"><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('monetization/invoice')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=100><col width=200><col width=*><col width=150><col width=150><col width=200></colgroup><thead><tr><th>Status</th><th>Invoice-Id</th><th>User</th><th>Amount</th><th>Points</th><th>Date</th></tr></thead><tbody><tr ng-repeat=\"invoice in invoices\"><td><span ng-switch=invoice.status><span ng-switch-when=0><span class=\"label label-info fusio-badge\">Open</span></span> <span ng-switch-when=1><span class=\"label label-success fusio-badge\">Payed</span></span> <span ng-switch-when=2><span class=\"label label-danger fusio-badge\">Deleted</span></span></span></td><td>{{invoice.displayId}}</td><td>{{invoice.user.name}}</td><td>{{invoice.amount | currency : symbol : 2}}</td><td>{{invoice.points}}</td><td>{{invoice.insertDate | date: 'short'}}</td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/log/detail.html',
    "<div class=modal-header><h3 class=modal-title>Detail</h3></div><div class=modal-body><uib-accordion close-others=false><div uib-accordion-group class=panel-default heading=Header is-open=true><pre class=fusio-log-detail-header>{{log.header}}</pre></div><div uib-accordion-group class=panel-default heading=Body is-open=true ng-if=log.body><pre class=fusio-log-detail-body>{{log.body}}</pre></div></uib-accordion><div ng-if=\"log.errors.length > 0\"><div class=fusio-grid><table class=table><colgroup><col width=*><col width=50></colgroup><thead><tr><th>Message</th><th></th></tr></thead><tbody><tr ng-repeat=\"error in log.errors\"><td>{{error.message}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(error) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-search\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><br></div><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/log/index.html',
    "<h1>Log</h1><div class=fusio-search><form name=logsSearchForm ng-submit=doFilter(filter)><div class=input-group><input class=form-control ng-model=filter.search placeholder=\"Search i.e. /foo/bar\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-filter\" ng-click=openFilterDialog()><span class=\"glyphicon glyphicon-filter\" aria-hidden=true></span></a></div></div></form></div><div class=fusio-grid><table class=table><colgroup><col width=80><col width=*><col width=200><col width=150><col width=150><col width=50></colgroup><thead><tr><th>Method</th><th>Path</th><th>User-Agent</th><th>IP</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"log in logs\"><td>{{log.method}}</td><td>{{log.path}}</td><td><div style=overflow:hidden;width:200px;white-space:nowrap; title={{log.userAgent}}>{{log.userAgent}}</div></td><td>{{log.ip}}</td><td>{{log.date | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(log) class=\"btn btn-default fusio-btn-detail\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/login/index.html',
    "<div class=fusio-login><div class=fusio-login-panel><header><h1>Fusio <span>({{version}})</span></h1></header><div class=fusio-login-panel-body><div uib-alert class=alert-danger ng-if=response>{{response}}</div><form name=loginForm method=post ng-submit=login(credentials) novalidate><div class=form-group><label for=username>Username:</label> <input id=username ng-model=credentials.username class=form-control></div><div class=form-group><label for=password>Password:</label> <input type=password id=password ng-model=credentials.password class=form-control></div><button type=submit class=\"btn btn-default\" ng-disabled=loading>Login</button></form></div></div></div>"
  );


  $templateCache.put('app/controller/logout/index.html',
    "<h1>Logout</h1><p>In progress ...</p>"
  );


  $templateCache.put('app/controller/marketplace/index.html',
    "<h1>Marketplace</h1><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=256><col width=*><col width=200></colgroup><thead><tr><th>Screenshot</th><th>Description</th><th></th></tr></thead><tbody><tr ng-repeat=\"(name, app) in apps\"><td><a href=\"{{ app.screenshot }}\" target=_blank><img width=256 src=\"{{ app.screenshot }}\"></a></td><td><b>{{ name }} ({{ app.version }})</b><br>{{ app.description }}</td><td><div class=fusio-options><a ng-if=app.local href=\"{{ app.local.startUrl }}\" target=_blank class=\"btn btn-primary fusio-btn-url\"><span class=\"glyphicon glyphicon-home\" aria-hidden=true></span></a> <a href=\"{{ app.website }}\" target=_blank class=\"btn btn-default fusio-btn-website\"><span class=\"glyphicon glyphicon-bookmark\" aria-hidden=true></span></a> <a ng-click=install(name) ng-disabled=\"working || app.local\" class=\"btn btn-default fusio-btn-install\"><span class=\"glyphicon glyphicon-download\" aria-hidden=true></span></a> <a ng-click=update(name) ng-disabled=\"working || !app.local\" class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-repeat\" aria-hidden=true></span></a> <a ng-click=remove(name) ng-disabled=\"working || !app.local\" class=\"btn btn-default fusio-btn-remove\"><span class=\"glyphicon glyphicon-trash\" aria-hidden=true></span></a></div></td></tr></tbody></table></div>"
  );


  $templateCache.put('app/controller/page/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=pageCreateForm ng-submit=create(page)><div class=form-group><label for=status>Status:</label> <select id=status class=form-control ng-model=page.status ng-options=\"status.key as status.value for status in statuuus\" aria-describedby=statusHelp></select> <span class=help-block id=statusHelp>Status of the page</span></div><div class=form-group><label for=title>Title:</label> <input id=title ng-model=page.title aria-describedby=titleHelp class=form-control> <span class=help-block id=titleHelp>Title of the page</span></div><div class=form-group><label for=content>Content:</label><div ui-ace=\"{mode: 'html'}\" id=content ng-model=page.content aria-describedby=contentHelp></div><span class=help-block id=contentHelp>Contains the HTML content of the page.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/page/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=pageDeleteForm ng-submit=delete(page)><input type=hidden ng-model=page.id value={{page.id}}><div class=form-group><label for=name>Title:</label> <input id=name ng-model=page.title ng-disabled=true class=form-control value={{page.title}}></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/page/index.html',
    "<h1>Page</h1><div class=fusio-search><form name=pageSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. page-title\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('consumer/page')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=row><div class=col-md-2><div class=\"panel panel-default\"><div class=panel-heading>Page</div><div class=panel-body><div class=fusio-route-navigation><ul><li ng-repeat=\"row in pages\"><a ng-href=#!/page/{{row.id}} title={{row.title}}><b ng-if=\"page.slug == row.slug\">{{row.title}}</b> <span ng-if=\"page.slug != row.slug\">{{row.title}}</span></a></li></ul></div><ul uib-pager total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul></div></div></div><div class=col-md-10><div class=\"panel panel-default\"><div class=panel-heading>&nbsp;{{page.title}}</div><div class=panel-body><div class=btn-group role=group><button type=button ng-click=openUpdateDialog(page) class=\"btn btn-primary fusio-btn-update\">Edit</button> <button type=button ng-click=openDeleteDialog(page) class=\"btn btn-danger fusio-btn-delete\">Delete</button></div><br><br><div ng-bind-html=page.content></div></div></div></div></div>"
  );


  $templateCache.put('app/controller/page/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=pageUpdateForm ng-submit=update(page)><input type=hidden ng-model=page.id value={{page.id}}><div class=form-group><label for=status>Status:</label> <select id=status class=form-control ng-model=page.status ng-options=\"status.key as status.value for status in statuuus\" aria-describedby=statusHelp></select> <span class=help-block id=statusHelp>Status of the page</span></div><div class=form-group><label for=title>Title:</label> <input id=title ng-model=page.title aria-describedby=titleHelp class=form-control> <span class=help-block id=titleHelp>Title of the page</span></div><div class=form-group><label for=content>Content:</label><div ui-ace=\"{mode: 'html'}\" id=content ng-model=page.content aria-describedby=contentHelp></div><span class=help-block id=contentHelp>Contains the HTML content of the page.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/plan/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=planCreateForm ng-submit=create(plan)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=plan.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the plan</span></div><div class=form-group><label for=description>Description:</label> <textarea type=text id=description ng-model=plan.description rows=3 aria-describedby=descriptionHelp class=form-control></textarea> <span class=help-block id=descriptionHelp>Detailed description of this plan</span></div><div class=form-group><label for=price>Price:</label> <input type=number id=price ng-model=plan.price aria-describedby=priceHelp min=1 step=any class=form-control> <span class=help-block id=priceHelp>The price how much this plan costs</span></div><div class=form-group><label for=points>Points:</label> <input type=number id=points ng-model=plan.points aria-describedby=pointsHelp class=form-control> <span class=help-block id=pointsHelp>The amount of points a user receives if he buys this plan</span></div><div class=form-group><label for=status>Period:</label> <select id=status ng-model=plan.period ng-options=\"period.id as period.name for period in periods\" aria-describedby=periodHelp class=form-control></select> <span class=help-block id=periodHelp>The period describes the time frame of the plan. If a period is available the user will receives after each period automatically an invoice.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/plan/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=planDeleteForm ng-submit=delete(plan)><input type=hidden ng-model=plan.id value={{plan.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=plan.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/plan/index.html',
    "<h1>Plan</h1><div class=fusio-search><form name=planSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. plan-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('monetization/plan')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=150><col width=150><col width=150><col width=150></colgroup><thead><tr><th>Name</th><th>Price</th><th>Points</th><th>Period</th><th></th></tr></thead><tbody><tr ng-repeat=\"plan in plans\"><td>{{plan.name}}</td><td>{{plan.price | currency : symbol : 2}}</td><td>{{plan.points}}</td><td><span ng-switch=plan.period><span ng-switch-when=0>None</span> <span ng-switch-when=1>1 Month</span> <span ng-switch-when=2>3 Month</span> <span ng-switch-when=3>6 Month</span> <span ng-switch-when=4>12 Month</span></span></td><td><div class=fusio-options><a ng-click=openUpdateDialog(plan) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(plan) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/plan/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=planUpdateForm ng-submit=update(plan)><input type=hidden ng-model=plan.id value={{plan.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=plan.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the plan</span></div><div class=form-group><label for=description>Description:</label> <textarea type=text id=description ng-model=plan.description rows=3 aria-describedby=descriptionHelp class=form-control></textarea> <span class=help-block id=descriptionHelp>Detailed description of this plan</span></div><div class=form-group><label for=price>Price:</label> <input type=number id=price ng-model=plan.price aria-describedby=priceHelp min=1 step=any class=form-control> <span class=help-block id=priceHelp>The price how much this plan costs</span></div><div class=form-group><label for=points>Points:</label> <input type=number id=points ng-model=plan.points aria-describedby=pointsHelp class=form-control> <span class=help-block id=pointsHelp>The amount of points a user receives if he buys this plan</span></div><div class=form-group><label for=status>Period:</label> <select id=status ng-model=plan.period ng-options=\"period.id as period.name for period in periods\" aria-describedby=periodHelp class=form-control></select> <span class=help-block id=periodHelp>The period describes the time frame of the plan. If a period is available the user will receives after each period automatically an invoice.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/rate/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=rateCreateForm ng-submit=create(rate)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=rate.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><div class=form-group><label for=priority>Priority:</label> <input type=number id=priority ng-model=rate.priority aria-describedby=priorityHelp class=form-control> <span class=help-block id=priorityHelp></span></div><div class=form-group><label>Throughput:</label><div class=row><div class=col-md-3><input type=number id=value ng-model=rate.rateLimit min=1 aria-describedby=unitHelp class=form-control></div><div class=col-md-2><label style=margin-top:6px;>request/s per</label></div><div class=col-md-3><input type=number id=unitValue ng-model=timespan.value min=1 aria-describedby=unitHelp class=form-control></div><div class=col-md-4><select id=status ng-model=timespan.unit ng-options=\"interval.key as interval.value for interval in intervals\" aria-describedby=statusHelp class=form-control></select></div></div><span class=help-block id=unitHelp></span></div><div uib-alert class=alert-info>The following table contains criteria which assign the incoming request to this rate. If <code>authenticated</code> is yes it is possible to apply the plan only to apps which have a specific parameter.</div><table class=table><colgroup><col width=25%><col width=25%><col width=50%><col width=50></colgroup><tr><th>Route</th><th>Authenticated</th><th>Parameters</th><th></th></tr><tr ng-repeat=\"row in rate.allocation\"><td><select ng-model=row.routeId ng-options=\"route.id as route.path for route in routes\" class=form-control></select></td><td><select ng-model=row.authenticated ng-options=\"st.key as st.value for st in status\" class=form-control></select></td><td><input ng-model=row.parameters ng-disabled=\"row.authenticated != 1\" class=form-control></td><td><a ng-click=removeAllocation($index) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></td></tr></table><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=addAllocation() class=\"btn btn-default fusio-btn-add\">Add</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/rate/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=rateDeleteForm ng-submit=delete(rate)><input type=hidden ng-model=rate.id value={{rate.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=rate.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/rate/index.html',
    "<h1>Rate</h1><div class=fusio-search><form name=rateSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. rate-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('consumer/rate')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=100></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"rate in rates\"><td>{{rate.name}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(rate) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(rate) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/rate/update.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=rateUpdateForm ng-submit=update(rate)><input type=hidden ng-model=rate.id value={{rate.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=rate.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><div class=form-group><label for=priority>Priority:</label> <input type=number id=priority ng-model=rate.priority aria-describedby=priorityHelp class=form-control> <span class=help-block id=priorityHelp></span></div><div class=form-group><label>Throughput:</label><div class=row><div class=col-md-3><input type=number id=value ng-model=rate.rateLimit min=1 aria-describedby=unitHelp class=form-control></div><div class=col-md-2><label style=margin-top:6px;>request/s per</label></div><div class=col-md-3><input type=number id=unitValue ng-model=timespan.value min=1 aria-describedby=unitHelp class=form-control></div><div class=col-md-4><select id=status ng-model=timespan.unit ng-options=\"interval.key as interval.value for interval in intervals\" aria-describedby=statusHelp class=form-control></select></div></div><span class=help-block id=unitHelp></span></div><div uib-alert class=alert-info>The following table contains criteria which assign the incoming request to this rate. If <code>authenticated</code> is yes it is possible to apply the plan only to apps which have a specific parameter.</div><table class=table><colgroup><col width=25%><col width=25%><col width=50%><col width=50></colgroup><tr><th>Route</th><th>Authenticated</th><th>Parameters</th><th></th></tr><tr ng-repeat=\"row in rate.allocation\"><td><select ng-model=row.routeId ng-options=\"route.id as route.path for route in routes\" class=form-control></select></td><td><select ng-model=row.authenticated ng-options=\"st.key as st.value for st in status\" class=form-control></select></td><td><input ng-model=row.parameters ng-disabled=\"row.authenticated != 1\" class=form-control></td><td><a ng-click=removeAllocation($index) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></td></tr></table><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=addAllocation() class=\"btn btn-default fusio-btn-add\">Add</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/role/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=roleCreateForm ng-submit=create(role)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=role.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><div class=form-group><label for=category>Category:</label> <select class=form-control id=category ng-model=role.categoryId ng-options=\"category.id as category.name for category in categories\" aria-describedby=categoryHelp></select> <span class=help-block id=categoryHelp>Default category for this role</span></div><uib-tabset><uib-tab heading=\"{{ category.name }}\" ng-repeat=\"category in categories\"><table class=\"table fusio-table-tab\"><colgroup><col width=20><col width=*></colgroup><tbody><tr ng-repeat=\"scope in category.scopes\"><td><input type=checkbox value={{scope.name}} id=scope-{{scope.id}} ng-checked=\"selected.indexOf(scope.name) > -1\" ng-click=toggleScope(scope.name)></td><td><label for=scope-{{scope.id}}>{{scope.name}}</label></td></tr></tbody></table></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/role/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=roleDeleteForm ng-submit=delete(role)><input type=hidden ng-model=role.id value={{role.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=role.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/role/index.html',
    "<h1>Role</h1><div class=fusio-search><form name=roleSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. role-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('system/role')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=100></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"role in roles\"><td>{{role.name}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(role) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(role) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/role/update.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=roleUpdateForm ng-submit=update(role)><input type=hidden ng-model=role.id value={{role.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=role.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp></span></div><div class=form-group><label for=category>Category:</label> <select class=form-control id=category ng-model=role.categoryId ng-options=\"category.id as category.name for category in categories\" aria-describedby=categoryHelp></select> <span class=help-block id=categoryHelp>Default category for this role</span></div><uib-tabset><uib-tab heading=\"{{ category.name }}\" ng-repeat=\"category in categories\"><table class=\"table fusio-table-tab\"><colgroup><col width=20><col width=*></colgroup><tbody><tr ng-repeat=\"scope in category.scopes\"><td><input type=checkbox value={{scope.name}} id=scope-{{scope.id}} ng-checked=\"selected.indexOf(scope.name) > -1\" ng-click=toggleScope(scope.name)></td><td><label for=scope-{{scope.id}}>{{scope.name}}</label></td></tr></tbody></table></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/routes/changelog.html',
    "<div class=modal-header><h3 class=modal-title>Changelog</h3></div><div class=modal-body><div class=fusio-grid><table class=table><thead><tr><th>Schema</th></tr></thead><tbody><tr ng-repeat=\"schema in changelog.schemas\"><td>{{schema.name}}</td></tr></tbody></table><table class=table><thead><tr><th>Action</th></tr></thead><tbody><tr ng-repeat=\"action in changelog.actions\"><td>{{action.name}}</td></tr></tbody></table><table class=table><thead><tr><th>Routes</th></tr></thead><tbody><tr ng-repeat=\"route in changelog.routes\"><td><code class=fusio-route-path>{{route.path}}</code></td></tr></tbody></table></div><br><button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/routes/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesCreateForm ng-submit=create(route)><div class=form-group><label for=path>Path:</label> <input id=path ng-model=route.path aria-describedby=pathHelp class=form-control> <span class=help-block id=pathHelp>Path of the API endpoint i.e. <code>/acme/news</code>. It is possible to use variable path fragments i.e. <code>/acme/:news</code>. Click <a ng-click=\"help.showDialog('api/routes#path')\">here</a> for more information</span></div><div class=form-group><label>Scopes:</label><tags-input ng-model=route.scopes placeholder=\"Add a scope\" aria-describedby=scopeHelp></tags-input><span class=help-block id=scopeHelp>Assign specific scopes to this route</span></div><uib-tabset active=indexVersion><uib-tab ng-repeat=\"version in route.config\" heading=v{{version.version}} index=$index><div class=form-group><label>Status:</label> <select class=form-control ng-model=version.status ng-disabled=true ng-options=\"status.key as status.value for status in statuuus\" aria-describedby=statusHelp></select> <span class=help-block id=statusHelp>The status of the API endpoint for this version. For more information about the impact click <a ng-click=\"help.showDialog('api/routes#status')\">here</a></span></div><uib-tabset active=indexMethod[indexVersion]><uib-tab ng-repeat=\"(method, config) in version.methods\" heading={{method}} index=$index><div class=checkbox><label><input type=checkbox ng-model=config.active ng-disabled=\"version.status != 4\" aria-describedby=activeHelp> <b>Active</b></label> <span class=help-block id=activeHelp>Whether the request method is allowed</span></div><div class=checkbox><label><input type=checkbox ng-model=config.public ng-disabled=\"version.status != 4\" aria-describedby=publicHelp> <b>Public</b></label> <span class=help-block id=publicHelp>Whether the endpoint can be requested without an access token</span></div><div class=form-group><label>Description:</label> <input class=form-control ng-model=config.description ng-disabled=\"version.status != 4\" aria-describedby=descriptionHelp> <span class=help-block id=descriptionHelp>A short description of the method</span></div><div class=form-group><label>Operation-Id:</label> <input class=form-control ng-model=config.operationId ng-disabled=\"version.status != 4\" aria-describedby=operationIdHelp> <span class=help-block id=operationIdHelp>Unique string used to identify the operation</span></div><div class=form-group><label>Parameters:</label><div class=row><div class=col-md-12><select class=form-control ng-model=config.parameters ng-options=\"schema.name as schema.name for schema in schemas\" ng-disabled=\"version.status != 4\" aria-describedby=parametersHelp><option value=\"\">No schema</option></select></div></div><span class=help-block id=parametersHelp>Optional a json schema which validates URI query parameters</span></div><div class=form-group><label>Request:</label><div class=row><div class=col-md-12><select class=form-control ng-model=config.request ng-options=\"schema.name as schema.name for schema in schemas\" ng-disabled=\"method == 'GET' || version.status != 4\" aria-describedby=requestHelp><option value=\"\">No schema</option></select></div></div><span class=help-block id=requestHelp>The allowed format for incoming requests. The <code>Passthru</code> schema forwards all incoming data unfiltered to the action</span></div><div class=form-group><label>Responses:</label><div ng-repeat=\"(code, statusTitle) in statusCodes\" class=row style=margin-bottom:6px; ng-if=config.responses[code]><div class=col-md-2><div style=margin-top:8px;><code>{{code}}</code></div></div><div class=col-md-10><select class=form-control ng-model=config.responses[code] ng-options=\"schema.name as schema.name for schema in schemas\" ng-disabled=\"version.status != 4\" aria-describedby=responsesHelp><option value=\"\">No schema</option></select></div></div><div class=row><div class=col-md-2><select class=form-control ng-model=responseCode ng-options=\"statusCode as statusTitle for (statusCode, statusTitle) in statusCodes\"></select></div><div class=col-md-10><a ng-click=addResponse(responseCode) ng-disabled=config.responses[responseCode] class=\"btn btn-default\">Add response</a></div></div><span class=help-block id=responsesHelp>The allowed format for outgoing responses. The <code>Passthru</code> schema forwards all outgoing data unfiltered to the client</span></div><div class=form-group><label>Action:</label><div class=row><div class=col-md-12><select class=form-control ng-model=config.action ng-options=\"action.name as action.name for action in actions\" ng-disabled=\"version.status != 4\" aria-describedby=actionHelp><option value=\"\">No action</option></select></div></div><span class=help-block id=actionHelp>The action which receives the request and produces a response</span></div><div class=form-group><label>Costs:</label> <input type=number class=form-control ng-model=config.costs ng-disabled=\"version.status != 4\" aria-describedby=costsHelp> <span class=help-block id=costsHelp>The amount of points a user needs to pay to invoke this request method</span></div></uib-tab></uib-tabset></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/routes/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesDeleteForm ng-submit=delete(route)><input type=hidden ng-model=route.id value={{route.id}}><div class=form-group><label for=path>Path:</label> <input id=path ng-model=route.path ng-disabled=true class=form-control value={{route.path}}></div><div uib-alert class=alert-danger><b>Note: This action will delete the selected route thus the route is not available anymore. This action cannot be undone.</b></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/routes/index.html',
    "<h1>Routes</h1><div class=fusio-search><form name=routesSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. /foo/bar\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-provider\" ng-click=openProviderDialog()><span class=\"glyphicon glyphicon-briefcase\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('api/routes')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=row><div class=col-md-2><div class=\"panel panel-default\"><div class=panel-heading>Path</div><div class=panel-body><div class=fusio-route-navigation><ul><li ng-repeat=\"row in routes\"><a ng-href=#!/routes/{{row.id}} title={{row.path}}><b ng-if=\"route.path == row.path\">{{row.path}}</b> <span ng-if=\"route.path != row.path\">{{row.path}}</span></a></li></ul></div><ul uib-pager total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul></div></div></div><div class=col-md-10><div class=\"panel panel-default\"><div class=panel-heading><a href={{baseUrl}}{{route.path}} class=fusio-route-path>&nbsp;{{route.path}}</a></div><div class=panel-body><div class=btn-group role=group><button type=button ng-click=openUpdateDialog(route) class=\"btn btn-primary fusio-btn-update\">Edit</button> <button type=button ng-click=showLogs(route) class=\"btn btn-default fusio-btn-logs\">Logs</button> <button type=button ng-click=openDeleteDialog(route) class=\"btn btn-danger fusio-btn-delete\">Delete</button></div><div class=\"pull-right fusio-route-scope\"><span ng-repeat=\"scope in route.scopes\">&nbsp;<span class=\"label label-primary\">{{scope}}</span></span></div><br><br><uib-tabset active=indexVersion><uib-tab ng-repeat=\"(index, version) in route.config\" index=$index heading=v{{version.version}}><div class=pull-right><span ng-if=\"version.status == 4\" class=\"label label-warning fusio-route-status\">Development</span> <span ng-if=\"version.status == 1\" class=\"label label-success fusio-route-status\">Production</span> <span ng-if=\"version.status == 2\" class=\"label label-info fusio-route-status\">Deprecated</span> <span ng-if=\"version.status == 3\" class=\"label label-default fusio-route-status\">Closed</span></div><uib-tabset><uib-tab ng-repeat=\"(method, config) in version.methods\" index=$index heading={{method}}><div class=form-group><label>Status:</label><div class=row><div class=col-md-12><span ng-if=config.active class=\"label label-success fusio-route-active\">Active</span> <span ng-if=!config.active class=\"label label-default fusio-route-active\">Inactive</span> <span ng-if=config.public class=\"label label-info fusio-route-public\">Public</span> <span ng-if=!config.public class=\"label label-info fusio-route-public\">Private</span></div></div></div><div class=form-group ng-if=config.description><label>Description:</label><div class=row><div class=\"col-md-12 fusio-route-description\"><p>{{config.description}}</p></div></div></div><div class=form-group ng-if=config.operationId><label>Operation-Id:</label><div class=row><div class=\"col-md-12 fusio-route-operation-id\"><code>{{config.operationId}}</code></div></div></div><div class=form-group ng-if=config.parameters><label>Parameters:</label><div class=row><div class=\"col-md-10 fusio-route-parameters\">{{config.parameters}}</div><div class=\"col-md-2 text-right\"><a ng-if=\"config.parameters && version.status == 4\" ng-click=showPreview(config.parameters) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-search\" aria-hidden=true></span></a></div></div></div><div class=form-group ng-if=config.request><label>Request:</label><div class=row><div class=\"col-md-10 fusio-route-request\">{{config.request}}</div><div class=\"col-md-2 text-right\"><a ng-if=\"config.request && version.status == 4\" ng-click=showPreview(config.request) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-search\" aria-hidden=true></span></a></div></div></div><div class=form-group ng-if=config.responses><label>Responses:</label><div ng-repeat=\"(code, schema) in config.responses\" class=row style=margin-bottom:6px;><div class=col-md-2><div style=margin-top:8px;><code>{{code}}</code></div></div><div class=\"col-md-8 fusio-route-responses\">{{schema}}</div><div class=\"col-md-2 text-right\"><a ng-if=\"schema && version.status == 4\" ng-click=showPreview(schema) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-search\" aria-hidden=true></span></a></div></div></div><div class=form-group ng-if=config.action><label>Action:</label><div class=row><div class=\"col-md-10 fusio-route-action\">{{config.action}}</div><div class=\"col-md-2 text-right\"></div></div></div><div class=form-group ng-if=config.costs><label>Costs:</label> {{config.costs}}</div></uib-tab></uib-tabset></uib-tab></uib-tabset></div></div></div></div>"
  );


  $templateCache.put('app/controller/routes/log.html',
    "<div class=modal-header><h3 class=modal-title>Logs</h3></div><div class=modal-body><div class=fusio-grid><table class=table><colgroup><col width=80><col width=200><col width=150><col width=150><col width=50></colgroup><thead><tr><th>Method</th><th>User-Agent</th><th>IP</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"log in logs\"><td>{{log.method}}</td><td><div style=overflow:hidden;width:200px;white-space:nowrap; title={{log.userAgent}}>{{log.userAgent}}</div></td><td>{{log.ip}}</td><td>{{log.date | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(log) class=\"btn btn-default\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><br><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/routes/provider.html',
    "<div class=modal-header><h3 class=modal-title>Provider</h3></div><div class=modal-body><div uib-alert class=alert-info>Through this form you can use a provider which automatically creates predefined schemas, actions and routes for you. All routes are placed under the provided base path. Click changelog to see all objects which this provider will create.</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesProviderForm ng-submit=create(route)><div class=form-group><label for=path>Base-Path:</label> <input id=path ng-model=route.path aria-describedby=pathHelp class=form-control> <span class=help-block id=pathHelp>Base-Path of the API endpoint i.e. <code>/acme/news</code>. The provider creates all routes under this path</span></div><div class=form-group><label>Scopes:</label><tags-input ng-model=route.scopes placeholder=\"Add a scope\" aria-describedby=scopeHelp></tags-input><span class=help-block id=scopeHelp>Assign specific scopes to the routes</span></div><div class=form-group><label for=class>Class:</label> <select id=class ng-model=provider ng-change=loadConfig() ng-options=\"provider.class as provider.name for provider in providers\" aria-describedby=classHelp class=\"form-control no-animate\"></select></div><div id=config-form></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=showChangelog() class=\"btn btn-default fusio-btn-changelog\">Changelog</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/routes/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesUpdateForm ng-submit=update(route)><input type=hidden ng-model=route.id value={{route.id}}><div class=form-group><label for=path>Path:</label> <input id=path ng-model=route.path ng-disabled=true class=form-control value={{route.path}}></div><div class=form-group><label>Scopes:</label><tags-input ng-model=route.scopes placeholder=\"Add a scope\" aria-describedby=scopeHelp></tags-input><span class=help-block id=scopeHelp>Assign specific scopes to this route</span></div><uib-tabset active=indexVersion><uib-tab ng-repeat=\"(index, version) in route.config\" index=$index heading=v{{version.version}}><div class=form-group><label>Status:</label> <select class=form-control ng-model=version.status ng-options=\"status.key as status.value for status in statuuus\" aria-describedby=statusHelp></select> <span class=help-block id=statusHelp>The status of the API endpoint for this version. For more information about the impact click <a ng-click=\"help.showDialog('api/routes#status')\">here</a></span></div><uib-tabset active=indexMethod[indexVersion]><uib-tab ng-repeat=\"(method, config) in version.methods\" index=$index heading={{method}}><div class=checkbox><label><input type=checkbox ng-model=config.active ng-disabled=\"version.status != 4\" aria-describedby=activeHelp> <b>Active</b></label> <span class=help-block id=activeHelp>Whether the request method is allowed</span></div><div class=checkbox><label><input type=checkbox ng-model=config.public ng-disabled=\"version.status != 4\" aria-describedby=publicHelp> <b>Public</b></label> <span class=help-block id=publicHelp>Whether the endpoint can be requested without an access token</span></div><div class=form-group><label>Description:</label> <input class=form-control ng-model=config.description ng-disabled=\"version.status != 4\" aria-describedby=descriptionHelp> <span class=help-block id=descriptionHelp>A short description of the method</span></div><div class=form-group><label>Operation-Id:</label> <input class=form-control ng-model=config.operationId ng-disabled=\"version.status != 4\" aria-describedby=operationIdHelp> <span class=help-block id=operationIdHelp>Unique string used to identify the operation</span></div><div class=form-group><label>Parameters:</label><div class=row><div class=col-md-12><select class=form-control ng-model=config.parameters ng-options=\"schema.name as schema.name for schema in schemas\" ng-disabled=\"version.status != 4\" aria-describedby=parametersHelp><option value=\"\">No schema</option></select></div></div><span class=help-block id=parametersHelp>Optional a json schema which validates URI query parameters</span></div><div class=form-group><label>Request:</label><div class=row><div class=col-md-12><select class=form-control ng-model=config.request ng-options=\"schema.name as schema.name for schema in schemas\" ng-disabled=\"method == 'GET' || version.status != 4\" aria-describedby=requestHelp><option value=\"\">No schema</option></select></div></div><span class=help-block id=requestHelp>The allowed format for incoming requests. The <code>Passthru</code> schema forwards all incoming data unfiltered to the action</span></div><div class=form-group><label>Responses:</label><div ng-repeat=\"(code, statusTitle) in statusCodes\" class=row style=margin-bottom:6px; ng-if=config.responses[code]><div class=col-md-2><div style=margin-top:8px;><code>{{code}}</code></div></div><div class=col-md-10><select class=form-control ng-model=config.responses[code] ng-options=\"schema.name as schema.name for schema in schemas\" ng-disabled=\"version.status != 4\" aria-describedby=responsesHelp><option value=\"\">No schema</option></select></div></div><div class=row><div class=col-md-2><select class=form-control ng-model=responseCode ng-options=\"statusCode as statusTitle for (statusCode, statusTitle) in statusCodes\" ng-disabled=\"version.status != 4\"></select></div><div class=col-md-10><a ng-click=addResponse(responseCode) ng-disabled=\"config.responses[responseCode] || version.status != 4\" class=\"btn btn-default\">Add response</a></div></div><span class=help-block id=responsesHelp>The allowed format for outgoing responses. The <code>Passthru</code> schema forwards all outgoing data unfiltered to the client</span></div><div class=form-group><label>Action:</label><div class=row><div class=col-md-12><select class=form-control ng-model=config.action ng-options=\"action.name as action.name for action in actions\" ng-disabled=\"version.status != 4\" aria-describedby=actionHelp><option value=\"\">No action</option></select></div></div><span class=help-block id=actionHelp>The action which receives the request and produces a response</span></div><div class=form-group><label>Costs:</label> <input type=number class=form-control ng-model=config.costs ng-disabled=\"version.status != 4\" aria-describedby=costsHelp> <span class=help-block id=costsHelp>The amount of points a user needs to pay to invoke this request method</span></div></uib-tab></uib-tabset></uib-tab></uib-tabset><a ng-click=addVersion() class=\"btn btn-default\">Add version</a> <button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/schema/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=schemasCreateForm ng-submit=create(schema)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=schema.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the schema must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=source>Schema:</label><div ui-ace=\"{mode: 'json'}\" id=source ng-model=schema.source aria-describedby=sourceHelp></div><span class=help-block id=sourceHelp>Schema which describes the data format. Click <a ng-click=\"help.showDialog('api/schema')\">here</a> for more information about the schema format.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/schema/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesDeleteForm ng-submit=delete(schema)><input type=hidden ng-model=schema.id value={{schema.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=schema.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/schema/index.html',
    "<h1>Schema</h1><div class=fusio-search><form name=schemasSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. schema-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('api/schema')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=row><div class=col-md-2><div class=\"panel panel-default\"><div class=panel-heading>Schema</div><div class=panel-body><div class=fusio-route-navigation><ul><li ng-repeat=\"row in schemas\"><a ng-href=#!/schema/{{row.id}} title={{row.name}}><b ng-if=\"schema.name == row.name\">{{row.name}}</b> <span ng-if=\"schema.name != row.name\">{{row.name}}</span></a></li></ul></div><ul uib-pager total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul></div></div></div><div class=col-md-10><div class=\"panel panel-default\"><div class=panel-heading>&nbsp;{{schema.name}}</div><div class=panel-body><div class=btn-group role=group><button type=button ng-click=openUpdateDialog(schema) class=\"btn btn-primary fusio-btn-update\">Edit</button> <button type=button ng-click=openUIDialog(schema) class=\"btn btn-default fusio-btn-ui\">UI-Schema</button> <button type=button ng-click=openDeleteDialog(schema) class=\"btn btn-danger fusio-btn-delete\">Delete</button></div><br><br><div ng-if=schema ng-bind-html=schema.preview></div></div></div></div></div>"
  );


  $templateCache.put('app/controller/schema/preview.html',
    "<div class=modal-header><h3 class=modal-title>Schema</h3></div><div class=modal-body><div ng-if=response ng-bind-html=response.preview class=fusio-schema-designer-preview></div><button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/schema/ui.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=updateUpdateForm ng-submit=update(schema)><input type=hidden ng-model=schema.id value={{schema.id}}><div class=form-group><label for=form>UI Schema:</label><div ui-ace=\"{mode: 'json'}\" id=form ng-model=schema.form aria-describedby=formHelp></div><span class=help-block id=formHelp>Optional an UI schema which arguments the schema. This can be used by clients to build a fitting UI based on the schema.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/schema/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=updateUpdateForm ng-submit=update(schema)><input type=hidden ng-model=schema.id value={{schema.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=schema.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the schema must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=source>Schema:</label><div ui-ace=\"{mode: 'json'}\" id=source ng-model=schema.source aria-describedby=sourceHelp></div><span class=help-block id=sourceHelp>Schema which describes the data format. Click <a ng-click=\"help.showDialog('api/schema')\">here</a> for more information about the schema format.</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/scope/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesCreateForm ng-submit=create(scope)><div class=form-group><label for=name>Name:</label> <input id=name ng-model=scope.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the scope must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=description>Description:</label> <input id=description ng-model=scope.description aria-describedby=descriptionHelp class=form-control> <span class=help-block id=descriptionHelp>Description of the scope</span></div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=60><col width=60><col width=60><col width=60><col width=60></colgroup><thead><tr><th>Route</th><th>GET</th><th>POST</th><th>PUT</th><th>PATCH</th><th>DELETE</th></tr></thead><tbody><tr ng-repeat=\"route in routes\"><td><code class=fusio-route-path>{{route.path}}</code></td><td><input type=checkbox ng-model=route.allowedMethods.get value=GET></td><td><input type=checkbox ng-model=route.allowedMethods.post value=POST></td><td><input type=checkbox ng-model=route.allowedMethods.put value=PUT></td><td><input type=checkbox ng-model=route.allowedMethods.patch value=PATCH></td><td><input type=checkbox ng-model=route.allowedMethods.delete value=DELETE></td></tr></tbody></table></div><br><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/scope/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesDeleteForm ng-submit=delete(scope)><input type=hidden ng-model=scope.id value={{scope.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=scope.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/scope/index.html',
    "<h1>Scope</h1><div class=fusio-search><form name=scopesSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. scope-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('consumer/scope')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=100></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"scope in scopes\"><td>{{scope.name}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(scope) ng-disabled=\"scope.id <= 3\" class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(scope) ng-disabled=\"scope.id <= 3\" class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/scope/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=routesUpdateForm ng-submit=update(scope)><input type=hidden ng-model=scope.id value={{scope.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=scope.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the scope must match the following regexp <code>[A-z0-9\\-\\_]{3,64}</code></span></div><div class=form-group><label for=description>Description:</label> <input id=description ng-model=scope.description aria-describedby=descriptionHelp class=form-control> <span class=help-block id=descriptionHelp>Description of the scope</span></div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=60><col width=60><col width=60><col width=60><col width=60></colgroup><thead><tr><th>Route</th><th>GET</th><th>POST</th><th>PUT</th><th>PATCH</th><th>DELETE</th></tr></thead><tbody><tr ng-repeat=\"route in routes\"><td><code class=fusio-route-path>{{route.path}}</code></td><td><input type=checkbox ng-model=route.allowedMethods.get value=GET></td><td><input type=checkbox ng-model=route.allowedMethods.post value=POST></td><td><input type=checkbox ng-model=route.allowedMethods.put value=PUT></td><td><input type=checkbox ng-model=route.allowedMethods.patch value=PATCH></td><td><input type=checkbox ng-model=route.allowedMethods.delete value=DELETE></td></tr></tbody></table></div><br><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/sdk/index.html',
    "<h1>SDK</h1><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=200></colgroup><thead><tr><th>Type</th><th></th></tr></thead><tbody><tr ng-repeat=\"(type, url) in types\"><td>{{ type }}</td><td><div class=fusio-options><a ng-if=url ng-click=download(url) class=\"btn btn-default fusio-btn-url\"><span class=\"glyphicon glyphicon-download\" aria-hidden=true></span></a> <a ng-click=generate(type) class=\"btn btn-primary fusio-btn-generate\"><span class=\"glyphicon glyphicon-repeat\" aria-hidden=true></span></a></div></td></tr></tbody></table></div>"
  );


  $templateCache.put('app/controller/statistic/filter.html',
    "<div class=modal-header><h3 class=modal-title>Filter</h3></div><div class=modal-body><form name=statisticFilterForm ng-submit=doFilter()><div class=form-group><label for=from>Date from/to:</label><div class=row><div class=col-md-6><input id=from type=date ng-model=filter.from required class=form-control aria-describedby=fromHelp></div><div class=col-md-6><input id=to type=date ng-model=filter.to required class=form-control aria-describedby=toHelp></div></div></div><div class=form-group><label for=app>App:</label> <select id=app ng-model=filter.appId ng-options=\"app.id as app.name for app in apps\" class=form-control aria-describedby=appHelp><option value=\"\">Every app</option><option value=-1>Anonymous</option></select> <span class=help-block id=appHelp></span></div><div class=form-group><label for=user>User:</label> <select id=user ng-model=filter.userId ng-options=\"user.id as user.name for user in users\" class=form-control aria-describedby=userHelp><option value=\"\">Every user</option></select> <span class=help-block id=userHelp></span></div><div class=form-group><label for=route>Route:</label> <select id=route ng-model=filter.routeId ng-options=\"route.id as route.path for route in routes\" class=form-control aria-describedby=routeHelp><option value=\"\">Every route</option></select> <span class=help-block id=routeHelp></span></div><div class=form-group><label for=ip>IP:</label> <input id=ip ng-model=filter.ip class=form-control aria-describedby=ipHelp> <span class=help-block id=ipHelp></span></div><div class=form-group><label for=userAgent>User-Agent:</label> <input id=userAgent ng-model=filter.userAgent class=form-control aria-describedby=userAgentHelp> <span class=help-block id=userAgentHelp></span></div><div class=form-group><label for=method>Method:</label> <select id=method ng-model=filter.method class=form-control aria-describedby=methodHelp><option value=\"\">Any</option><option value=GET>GET</option><option value=POST>POST</option><option value=PUT>PUT</option><option value=DELETE>DELETE</option></select> <span class=help-block id=methodHelp></span></div><div class=form-group><label for=path>Path:</label> <input id=path ng-model=filter.path class=form-control aria-describedby=pathHelp> <span class=help-block id=pathHelp></span></div><div class=form-group><label for=header>Header:</label> <input id=header ng-model=filter.header class=form-control aria-describedby=headerHelp> <span class=help-block id=headerHelp></span></div><div class=form-group><label for=body>Body:</label> <input id=body ng-model=filter.body class=form-control aria-describedby=bodyHelp> <span class=help-block id=bodyHelp></span></div><button type=submit class=\"btn btn-primary\">Filter</button> <button type=button ng-click=close() class=\"btn btn-default\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/statistic/index.html',
    "<h1>Statistic</h1><div class=fusio-search><form name=logsSearchForm ng-submit=doFilter()><div class=row><div class=col-md-2><select id=statistic ng-model=statistic ng-change=doFilter() ng-options=\"statistic.value as statistic.name for statistic in statistics\" class=form-control></select></div><div class=col-md-10><div class=input-group><input class=form-control ng-model=filter.search placeholder=\"Search i.e. /foo/bar\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-filter\" ng-click=openFilterDialog()><span class=\"glyphicon glyphicon-filter\" aria-hidden=true></span></a></div></div></div></div></form></div><div class=\"panel panel-default\"><div class=panel-heading>{{ getStatisticName(statistic) }} ({{filter.from | date:'shortDate'}} - {{filter.to | date:'shortDate'}})</div><div class=panel-body><div class=fusio-statistic><canvas id=statisticCanvas class=\"chart chart-line\" height=400 chart-options=\"{'responsive':true,'maintainAspectRatio':false}\" chart-data=chart.data chart-labels=chart.labels chart-series=chart.series></canvas></div></div></div>"
  );


  $templateCache.put('app/controller/subscription/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=subscriptionCreateForm ng-submit=create(subscription)><div class=form-group><label for=event>Event:</label> <select id=event ng-model=subscription.eventId ng-options=\"event.id as event.name for event in events\" class=form-control aria-describedby=eventHelp></select> <span class=help-block id=eventHelp>The event type</span></div><div class=form-group><label for=user>User:</label> <select id=user ng-model=subscription.userId ng-options=\"user.id as user.name for user in users\" class=form-control aria-describedby=userHelp></select> <span class=help-block id=userHelp>The assigned user of the event</span></div><div class=form-group><label for=endpoint>Endpoint:</label> <input type=url id=endpoint ng-model=subscription.endpoint aria-describedby=endpointHelp class=form-control> <span class=help-block id=nameHelp>Url of the endpoint which gets called</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/subscription/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=subscriptionDeleteForm ng-submit=delete(subscription)><input type=hidden ng-model=subscription.id value={{subscription.id}}><div class=form-group><label for=endpoint>Endpoint:</label> <input id=endpoint ng-model=subscription.endpoint ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/subscription/index.html',
    "<h1>Subscription</h1><div class=fusio-search><form name=subscriptionSearchForm ng-submit=doSearch(search)><div class=row><div class=col-md-12><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. subscription-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('consumer/subscription')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=150></colgroup><thead><tr><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat=\"subscription in subscriptions\"><td>{{subscription.endpoint}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(subscription) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(subscription) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/subscription/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=subscriptionUpdateForm ng-submit=update(subscription)><input type=hidden ng-model=subscription.id value={{subscription.id}}><div class=form-group><label for=endpoint>Endpoint:</label> <input type=url id=endpoint ng-model=subscription.endpoint aria-describedby=endpointHelp class=form-control> <span class=help-block id=nameHelp>Url of the endpoint which gets called</span></div><uib-tabset><uib-tab heading=Responses><table class=\"table fusio-table-tab fusio-table-tab-token\"><colgroup><col width=50><col width=50><col width=*><col width=150></colgroup><tbody><tr ng-repeat=\"response in subscription.responses\"><td><span ng-if=\"response.code >= 200 && response.code < 300\" class=\"label label-success\">{{response.code}}</span> <span ng-if=\"response.code >= 300 && response.code < 400\" class=\"label label-info\">{{response.code}}</span> <span ng-if=\"response.code >= 400 && response.code < 500\" class=\"label label-warning\">{{response.code}}</span> <span ng-if=\"response.code >= 500 && response.code < 600\" class=\"label label-danger\">{{response.code}}</span> <span ng-if=!response.code class=\"label label-default\">-</span></td><td>{{response.attempts}}</td><td>{{response.error}}</td><td>{{response.executeDate | date: 'short'}}</td></tr></tbody></table></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/token/detail.html',
    "<div class=modal-header><h3 class=modal-title>Detail</h3></div><div class=modal-body><form name=tokenForm><input type=hidden ng-model=token.id value={{token.id}}><div class=form-group><label for=app>App:</label> <input id=app ng-model=token.app.name ng-disabled=true class=form-control></div><div class=form-group><label for=user>User:</label> <input id=user ng-model=token.user.name ng-disabled=true class=form-control></div><div class=form-group><label for=status>Status:</label> <select id=status ng-model=token.status ng-options=\"status.key as status.value for status in statuuus\" ng-disabled=true class=form-control></select></div><div class=form-group><label for=token>Token:</label> <input id=token ng-model=token.token ng-disabled=true class=form-control></div><div class=form-group><label for=scope>Scope:</label> <input id=scope ng-model=token.scope ng-disabled=true class=form-control></div><div class=form-group><label for=ip>IP:</label> <input id=ip ng-model=token.ip ng-disabled=true class=form-control></div><div class=form-group><label for=expire>Expire:</label> <input id=expire ng-model=token.expire ng-disabled=true class=form-control></div><div class=form-group><label for=date>Date:</label> <input id=date ng-model=token.date ng-disabled=true class=form-control></div><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/token/filter.html',
    "<div class=modal-header><h3 class=modal-title>Filter</h3></div><div class=modal-body><form name=statisticFilterForm ng-submit=doFilter()><div class=form-group><label for=from>Date from/to:</label><div class=row><div class=col-md-6><input id=from type=date ng-model=filter.from required class=form-control aria-describedby=fromHelp></div><div class=col-md-6><input id=to type=date ng-model=filter.to required class=form-control aria-describedby=toHelp></div></div></div><div class=form-group><label for=app>App:</label> <select id=app ng-model=filter.appId ng-options=\"app.id as app.name for app in apps\" class=form-control aria-describedby=appHelp><option value=\"\">Every app</option><option value=-1>Anonymous</option></select> <span class=help-block id=appHelp></span></div><div class=form-group><label for=user>User:</label> <select id=user ng-model=filter.userId ng-options=\"user.id as user.name for user in users\" class=form-control aria-describedby=userHelp><option value=\"\">Every user</option></select> <span class=help-block id=userHelp></span></div><div class=form-group><label for=scope>Scope:</label> <input id=scope ng-model=filter.scope class=form-control aria-describedby=scopeHelp> <span class=help-block id=scopeHelp></span></div><div class=form-group><label for=ip>IP:</label> <input id=ip ng-model=filter.ip class=form-control aria-describedby=ipHelp> <span class=help-block id=ipHelp></span></div><button type=submit class=\"btn btn-primary\">Filter</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/token/index.html',
    "<h1>Token</h1><div class=fusio-search><form name=tokenSearchForm ng-submit=doFilter(filter)><div class=input-group><input class=form-control ng-model=filter.search placeholder=\"Search i.e. scope\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-filter\" ng-click=openFilterDialog()><span class=\"glyphicon glyphicon-filter\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=100><col width=*><col width=150><col width=200><col width=50></colgroup><thead><tr><th>Status</th><th>Scope</th><th>IP</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"token in tokens\"><td><span ng-switch=token.status><span ng-switch-when=2><span class=\"label label-danger fusio-badge\">Deleted</span></span> <span ng-switch-when=1><span class=\"label label-success fusio-badge\">Active</span></span></span></td><td><span ng-repeat=\"scope in token.scope.slice(0, 2)\" class=\"label label-primary fusio-badge\">{{scope}}</span> <span ng-if=\"token.scope.length > 2\">(+{{ token.scope.length - 2 }} scopes)</span></td><td>{{token.ip}}</td><td>{{token.date | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(token) class=\"btn btn-default fusio-btn-detail\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=removeToken(token) ng-disabled=\"token.status == 2\" class=\"btn btn-default fusio-btn-remove\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/transaction/detail.html',
    "<div class=modal-header><h3 class=modal-title>Detail</h3></div><div class=modal-body><form name=transactionDetailForm><div class=form-group><label for=provider>Provider:</label> <input id=provider ng-model=transaction.provider ng-disabled=true class=form-control></div><div class=form-group><label for=transactionId>Transaction-Id:</label> <input id=transactionId ng-model=transaction.transactionId ng-disabled=true class=form-control></div><div class=form-group><label for=amount>Amount:</label> <input type=number id=amount ng-model=transaction.amount ng-disabled=true class=form-control></div><div class=form-group><label for=date>Date:</label> <input id=date ng-model=transaction.insertDate ng-disabled=true class=form-control></div></form><button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></div>"
  );


  $templateCache.put('app/controller/transaction/index.html',
    "<h1>Log</h1><div class=fusio-search><form name=logsSearchForm ng-submit=doFilter(filter)><div class=input-group><input class=form-control ng-model=filter.search placeholder=\"Search i.e. paypal\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-filter\" ng-click=openFilterDialog()><span class=\"glyphicon glyphicon-filter\" aria-hidden=true></span></a></div></div></form></div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=150><col width=150><col width=50></colgroup><thead><tr><th>Transaction-Id</th><th>Amount</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"transaction in transactions\"><td>{{transaction.transactionId}}</td><td>{{transaction.amount | currency : symbol : 2}}</td><td>{{transaction.insertDate | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openDetailDialog(transaction) class=\"btn btn-default fusio-btn-detail\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/user/create.html',
    "<div class=modal-header><h3 class=modal-title>Create</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=usersCreateForm ng-submit=create(user)><div class=form-group><label for=status>Status:</label> <select id=status ng-model=user.status ng-options=\"status.id as status.name for status in statuuus\" aria-describedby=statusHelp class=form-control></select> <span class=help-block id=statusHelp>The status of the user</span></div><div class=form-group><label for=role>Role:</label> <select class=form-control id=role ng-model=user.roleId ng-options=\"role.id as role.name for role in roles\" aria-describedby=roleHelp></select> <span class=help-block id=roleHelp>Role for this user</span></div><div class=form-group><label for=name>Name:</label> <input id=name ng-model=user.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the user must match the following regexp <code>[A-z0-9\\-\\_\\.]{3,32}</code></span></div><div class=form-group><label for=email>Email:</label> <input type=email id=email ng-model=user.email aria-describedby=emailHelp class=form-control> <span class=help-block id=emailHelp>Email address of the user</span></div><div class=form-group><label for=password>Password:</label> <input type=password id=password ng-model=user.password aria-describedby=passwordHelp class=form-control> <span class=help-block id=passwordHelp>Password of the account</span></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/user/delete.html',
    "<div class=modal-header><h3 class=modal-title>Delete</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=usersDeleteForm ng-submit=delete(user)><input type=hidden ng-model=user.id value={{user.id}}><div class=form-group><label for=name>Name:</label> <input id=name ng-model=user.name ng-disabled=true class=form-control></div><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );


  $templateCache.put('app/controller/user/index.html',
    "<h1>User</h1><div class=fusio-search><form name=usersSearchForm ng-submit=doSearch(search)><div class=input-group><input class=form-control ng-model=search placeholder=\"Search i.e. user-name\"><div class=input-group-btn><a class=\"btn btn-primary fusio-btn-create\" ng-click=openCreateDialog()><span class=\"glyphicon glyphicon-plus\" aria-hidden=true></span></a></div><div class=input-group-btn><a class=\"btn btn-default\" ng-click=\"help.showDialog('consumer/user')\"><span class=\"glyphicon glyphicon-question-sign\" aria-hidden=true></span></a></div></div></form></div><div uib-alert class=alert-success close=closeResponse() ng-if=\"response.success === true\">{{response.message}}</div><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><div class=fusio-grid><table class=table><colgroup><col width=*><col width=150><col width=100></colgroup><thead><tr><th>Name</th><th>Date</th><th></th></tr></thead><tbody><tr ng-repeat=\"user in users\"><td>{{user.name}}</td><td>{{user.date | date: 'short'}}</td><td><div class=fusio-options><a ng-click=openUpdateDialog(user) class=\"btn btn-default fusio-btn-update\"><span class=\"glyphicon glyphicon-cog\" aria-hidden=true></span></a> <a ng-click=openDeleteDialog(user) class=\"btn btn-default fusio-btn-delete\"><span class=\"glyphicon glyphicon-remove\" aria-hidden=true></span></a></div></td></tr></tbody></table></div><ul uib-pagination total-items=totalResults items-per-page=16 ng-model=startIndex ng-change=pageChanged() max-size=10></ul>"
  );


  $templateCache.put('app/controller/user/update.html',
    "<div class=modal-header><h3 class=modal-title>Update</h3></div><div class=modal-body><div uib-alert class=alert-danger close=closeResponse() ng-if=\"response.success === false\">{{response.message}}</div><form name=userUpdateForm ng-submit=update(user)><input type=hidden ng-model=user.id value={{user.id}}><div class=form-group><label for=status>Status:</label> <select id=status ng-model=user.status ng-options=\"status.id as status.name for status in statuuus\" aria-describedby=statusHelp class=form-control></select> <span class=help-block id=statusHelp>The status of the user</span></div><div class=form-group><label for=name>Name:</label> <input id=name ng-model=user.name aria-describedby=nameHelp class=form-control> <span class=help-block id=nameHelp>Name of the user must match the following regexp <code>[A-z0-9\\-\\_\\.]{3,32}</code></span></div><div class=form-group><label for=email>Email:</label> <input type=email id=email ng-model=user.email aria-describedby=emailHelp class=form-control> <span class=help-block id=emailHelp>Email address of the user</span></div><div class=form-group><label for=points>Points:</label> <input type=number id=points ng-model=user.points ng-disabled=true aria-describedby=pointsHelp class=form-control> <span class=help-block id=pointsHelp>The amount of available points</span></div><uib-tabset><uib-tab heading=\"{{ category.name }}\" ng-repeat=\"category in categories\"><table class=\"table fusio-table-tab\"><colgroup><col width=20><col width=*></colgroup><tbody><tr ng-repeat=\"scope in category.scopes\"><td><input type=checkbox value={{scope.name}} id=scope-{{scope.id}} ng-checked=\"selected.indexOf(scope.name) > -1\" ng-click=toggleScope(scope.name)></td><td><label for=scope-{{scope.id}}>{{scope.name}}</label></td></tr></tbody></table></uib-tab></uib-tabset><button type=submit class=\"btn btn-primary fusio-btn-save\">Save</button> <button type=button ng-click=close() class=\"btn btn-default fusio-btn-cancel\">Cancel</button></form></div>"
  );

}]);
